/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.command.impl.SaveHistoryTaskCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.env.TaskDueDefinitionProvider;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.CancelTaskInterceptor;
import com.bstek.uflo.model.task.DateUnit;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskAppointor;
import com.bstek.uflo.model.task.TaskParticipator;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.model.task.reminder.ReminderType;
import com.bstek.uflo.model.task.reminder.TaskReminder;
import com.bstek.uflo.process.assign.Assignee;
import com.bstek.uflo.process.assign.AssigneeProvider;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.handler.AssignmentHandler;
import com.bstek.uflo.process.handler.CountersignHandler;
import com.bstek.uflo.process.listener.GlobalTaskListener;
import com.bstek.uflo.process.listener.TaskListener;
import com.bstek.uflo.process.node.AssignmentType;
import com.bstek.uflo.process.node.FormElement;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.process.node.UserData;
import com.bstek.uflo.process.node.calendar.BusinessCalendar;
import com.bstek.uflo.process.node.exception.AssignExprNullException;
import com.bstek.uflo.process.node.exception.AssignerNotFoundException;
import com.bstek.uflo.process.node.exception.SwimlaneNotExistException;
import com.bstek.uflo.process.node.exception.UnsupportAssignmentException;
import com.bstek.uflo.process.node.reminder.CalendarInfo;
import com.bstek.uflo.process.node.reminder.DueAction;
import com.bstek.uflo.process.node.reminder.DueDefinition;
import com.bstek.uflo.process.node.reminder.PeriodReminder;
import com.bstek.uflo.process.node.reminder.Reminder;
import com.bstek.uflo.process.security.Authority;
import com.bstek.uflo.process.security.ComponentAuthority;
import com.bstek.uflo.process.swimlane.Swimlane;
import com.bstek.uflo.query.TaskQuery;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.service.TaskService;
import com.bstek.uflo.utils.IDGenerator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.quartz.spi.OperableTrigger;
import org.springframework.context.ApplicationContext;

public class TaskNode
extends Node {
    private static final long serialVersionUID = -1984323879432140639L;
    private String taskName;
    private TaskType taskType;
    private boolean allowSpecifyAssignee;
    private int countersignMultiplicity;
    private int countersignPercentMultiplicity;
    private String countersignExpression;
    private String countersignHandler;
    private AssignmentType assignmentType;
    private List<Assignee> assignees;
    private String assignmentHandlerBean;
    private String swimlane;
    private String expression;
    private String url;
    private String formTemplate;
    private String taskListenerBean;
    private DueDefinition dueDefinition;
    private List<ComponentAuthority> componentAuthorities;
    private List<FormElement> formElements;
    private List<UserData> userData;

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        int size;
        TaskListener taskListener;
        boolean doNext;
        if (StringUtils.isNotEmpty((String)this.taskListenerBean) && (doNext = (taskListener = (TaskListener)context.getApplicationContext().getBean(this.taskListenerBean)).beforeTaskCreate(context, processInstance, this))) {
            return true;
        }
        Collection<GlobalTaskListener> coll = this.fetchGlobalTaskListener(context);
        for (GlobalTaskListener listener : coll) {
            listener.beforeTaskCreate(context, processInstance, this);
        }
        if (this.allowSpecifyAssignee && (size = this.processAllowSpecifyAssignee(context, processInstance)) > 0) {
            return false;
        }
        if (this.assignmentType.equals((Object)AssignmentType.Handler)) {
            this.processAssignmentHandler(context, processInstance, this.assignmentHandlerBean);
        } else if (this.assignmentType.equals((Object)AssignmentType.Swimlane)) {
            this.processSwimlane(context, processInstance);
        } else if (this.assignmentType.equals((Object)AssignmentType.Assignee)) {
            this.processAssignees(context, processInstance, this.assignees);
        } else if (this.assignmentType.equals((Object)AssignmentType.ProcessPromoter)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(processInstance.getPromoter());
            this.createTasks(context, processInstance, users);
        } else if (this.assignmentType.equals((Object)AssignmentType.Expression)) {
            this.processExpression(context, processInstance, this.expression);
        } else {
            throw new UnsupportAssignmentException("Unsupport current assignment type [" + (Object)((Object)this.assignmentType) + "]", this);
        }
        return false;
    }

    private int processAllowSpecifyAssignee(Context context, ProcessInstance processInstance) {
        TaskService taskService = (TaskService)context.getApplicationContext().getBean("uflo.taskService");
        List<TaskAppointor> appointors = taskService.getTaskAppointors(this.getName(), processInstance.getRootId());
        if (appointors != null && appointors.size() > 0) {
            ArrayList<String> owners = new ArrayList<String>();
            for (TaskAppointor ta : appointors) {
                owners.add(ta.getOwner());
            }
            if (owners.size() == 0) {
                return 0;
            }
            this.createTasks(context, processInstance, owners);
            return appointors.size();
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getAssigneeUsers(Context context, ProcessInstance processInstance) {
        ArrayList<String> resultUsers = new ArrayList<String>();
        ApplicationContext applicationContext = context.getApplicationContext();
        if (this.assignmentType.equals((Object)AssignmentType.Handler)) {
            AssignmentHandler handler = (AssignmentHandler)applicationContext.getBean(this.assignmentHandlerBean);
            Collection<String> users = handler.handle(this, processInstance, context);
            resultUsers.addAll(users);
            return resultUsers;
        } else if (this.assignmentType.equals((Object)AssignmentType.Swimlane)) {
            Swimlane lane = context.getProcessService().getProcessById(processInstance.getProcessId()).getSwimlane(this.swimlane);
            if (lane == null) {
                throw new SwimlaneNotExistException("Swimlane [" + this.swimlane + "] is not exist!", this);
            }
            if (lane.getAssignmentType().equals((Object)AssignmentType.Handler)) {
                AssignmentHandler handler = (AssignmentHandler)applicationContext.getBean(lane.getAssignmentHandlerBean());
                Collection<String> users = handler.handle(this, processInstance, context);
                resultUsers.addAll(users);
                return resultUsers;
            } else if (lane.getAssignmentType().equals((Object)AssignmentType.Expression)) {
                List<String> users = this.getExpressionUsers(context, processInstance, lane.getExpression());
                resultUsers.addAll(users);
                return resultUsers;
            } else if (lane.getAssignmentType().equals((Object)AssignmentType.ProcessPromoter)) {
                resultUsers.add(processInstance.getPromoter());
                return resultUsers;
            } else {
                if (!lane.getAssignmentType().equals((Object)AssignmentType.Assignee)) throw new UnsupportAssignmentException("Unsupport swimlane [" + this.swimlane + "] assignment type [" + (Object)((Object)this.assignmentType) + "]", this);
                ArrayList<String> users = new ArrayList<String>();
                this.retriveAssignees(lane.getAssignees(), context, processInstance, users);
                resultUsers.addAll(users);
            }
            return resultUsers;
        } else if (this.assignmentType.equals((Object)AssignmentType.Assignee)) {
            ArrayList<String> users = new ArrayList<String>();
            this.retriveAssignees(this.assignees, context, processInstance, users);
            resultUsers.addAll(users);
            return resultUsers;
        } else if (this.assignmentType.equals((Object)AssignmentType.ProcessPromoter)) {
            resultUsers.add(processInstance.getPromoter());
            return resultUsers;
        } else {
            if (!this.assignmentType.equals((Object)AssignmentType.Expression)) throw new UnsupportAssignmentException("Unsupport current assignment type [" + (Object)((Object)this.assignmentType) + "]", this);
            List<String> users = this.getExpressionUsers(context, processInstance, this.expression);
            resultUsers.addAll(users);
        }
        return resultUsers;
    }

    private void processAssignmentHandler(Context context, ProcessInstance processInstance, String bean) {
        AssignmentHandler handler = (AssignmentHandler)context.getApplicationContext().getBean(bean);
        Collection<String> users = handler.handle(this, processInstance, context);
        this.createTasks(context, processInstance, users);
    }

    private void processSwimlane(Context context, ProcessInstance processInstance) {
        Swimlane lane = context.getProcessService().getProcessById(processInstance.getProcessId()).getSwimlane(this.swimlane);
        if (lane == null) {
            throw new SwimlaneNotExistException("Swimlane [" + this.swimlane + "] is not exist!", this);
        }
        if (lane.getAssignmentType().equals((Object)AssignmentType.Handler)) {
            this.processAssignmentHandler(context, processInstance, lane.getAssignmentHandlerBean());
        } else if (lane.getAssignmentType().equals((Object)AssignmentType.Expression)) {
            this.processExpression(context, processInstance, lane.getExpression());
        } else if (lane.getAssignmentType().equals((Object)AssignmentType.ProcessPromoter)) {
            ArrayList<String> users = new ArrayList<String>();
            users.add(processInstance.getPromoter());
            this.createTasks(context, processInstance, users);
        } else if (lane.getAssignmentType().equals((Object)AssignmentType.Assignee)) {
            this.processAssignees(context, processInstance, lane.getAssignees());
        } else {
            throw new UnsupportAssignmentException("Unsupport swimlane [" + this.swimlane + "] assignment type [" + (Object)((Object)this.assignmentType) + "]", this);
        }
    }

    private void processExpression(Context context, ProcessInstance processInstance, String expr) {
        List<String> users = this.getExpressionUsers(context, processInstance, expr);
        this.createTasks(context, processInstance, users);
    }

    private List<String> getExpressionUsers(Context context, ProcessInstance processInstance, String expr) {
        Object obj = context.getExpressionContext().eval(processInstance, expr);
        if (obj == null) {
            throw new AssignExprNullException("Expression " + expr + " value is null", this);
        }
        ArrayList<String> users = new ArrayList<String>();
        if (obj instanceof String) {
            String user = (String)obj;
            users.add(user);
        } else if (obj instanceof String[]) {
            for (String user : (String[])obj) {
                users.add(user);
            }
        } else if (obj instanceof Collection) {
            users.addAll((Collection)obj);
        } else {
            throw new UnsupportAssignmentException("Unsupport expression " + expr + " value type :" + obj.getClass().getName(), this);
        }
        return users;
    }

    private void createTasks(Context context, ProcessInstance processInstance, Collection<String> owners) {
        if (owners == null || owners.size() == 0) {
            throw new AssignerNotFoundException("Task node " + this.getName() + " must be have one assignee at least!", this);
        }
        ArrayList<String> users = new ArrayList<String>();
        for (String owner : owners) {
            if (users.contains(owner)) continue;
            users.add(owner);
        }
        TaskListener taskListener = null;
        if (StringUtils.isNotEmpty((String)this.taskListenerBean)) {
            taskListener = (TaskListener)context.getApplicationContext().getBean(this.taskListenerBean);
        }
        Collection<GlobalTaskListener> coll = this.fetchGlobalTaskListener(context);
        Session session = context.getSession();
        if (this.taskType.equals((Object)TaskType.Normal)) {
            Task task = this.createTask(context, processInstance);
            if (users.size() == 1) {
                String user = (String)users.iterator().next();
                task.setAssignee(user);
                task.setOwner(user);
                task.setType(this.taskType);
                session.save((Object)task);
                Date dueDate = this.createReminder(processInstance, task, context);
                if (dueDate == null) {
                    DueDefinition dueDef = this.getCustomDueDefinition(processInstance, task, context.getApplicationContext());
                    dueDate = dueDef != null ? this.computeDueReminderStartdate(context, dueDef) : this.computeDueReminderStartdate(context, this.dueDefinition);
                }
                task.setDuedate(dueDate);
                if (taskListener != null) {
                    taskListener.onTaskCreate(context, task);
                }
                for (GlobalTaskListener listener : coll) {
                    listener.onTaskCreate(context, task);
                }
            } else {
                task.setType(TaskType.Participative);
                task.setState(TaskState.Ready);
                session.save((Object)task);
                Date dueDate = this.createReminder(processInstance, task, context);
                if (dueDate == null) {
                    DueDefinition dueDef = this.getCustomDueDefinition(processInstance, task, context.getApplicationContext());
                    dueDate = dueDef != null ? this.computeDueReminderStartdate(context, dueDef) : this.computeDueReminderStartdate(context, this.dueDefinition);
                }
                task.setDuedate(dueDate);
                long taskId = task.getId();
                for (String user : users) {
                    TaskParticipator p = new TaskParticipator();
                    p.setId(IDGenerator.getInstance().nextId());
                    p.setTaskId(taskId);
                    p.setUser(user);
                    session.save((Object)p);
                }
                if (taskListener != null) {
                    taskListener.onTaskCreate(context, task);
                }
                for (GlobalTaskListener listener : coll) {
                    listener.onTaskCreate(context, task);
                }
            }
        } else if (this.taskType.equals((Object)TaskType.Countersign)) {
            for (String user : users) {
                Task task = this.createTask(context, processInstance);
                task.setAssignee(user);
                task.setOwner(user);
                task.setCountersignCount(users.size());
                task.setType(this.taskType);
                session.save((Object)task);
                Date dueDate = this.createReminder(processInstance, task, context);
                if (dueDate == null) {
                    DueDefinition dueDef = this.getCustomDueDefinition(processInstance, task, context.getApplicationContext());
                    dueDate = dueDef != null ? this.computeDueReminderStartdate(context, dueDef) : this.computeDueReminderStartdate(context, this.dueDefinition);
                }
                task.setDuedate(dueDate);
                if (taskListener != null) {
                    taskListener.onTaskCreate(context, task);
                }
                for (GlobalTaskListener listener : coll) {
                    listener.onTaskCreate(context, task);
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported current task type :" + (Object)((Object)this.taskType));
        }
    }

    private Task createTask(Context context, ProcessInstance processInstance) {
        Task task = new Task();
        task.setId(IDGenerator.getInstance().nextId());
        task.setNodeName(this.getName());
        if (StringUtils.isNotEmpty((String)this.taskName)) {
            task.setTaskName(context.getExpressionContext().evalString(processInstance, this.taskName));
        } else {
            String newTaskName = this.getLabel();
            if (StringUtils.isEmpty((String)newTaskName)) {
                newTaskName = this.getName();
            }
            task.setTaskName(newTaskName);
        }
        task.setRootProcessInstanceId(processInstance.getRootId());
        task.setDescription(context.getExpressionContext().evalString(processInstance, this.getDescription()));
        task.setCreateDate(new Date());
        task.setState(TaskState.Created);
        task.setProcessId(this.getProcessId());
        task.setProcessInstanceId(processInstance.getId());
        task.setPrevTask(processInstance.getCurrentTask());
        task.setBusinessId(processInstance.getBusinessId());
        task.setSubject(processInstance.getSubject());
        String targetUrl = this.getUrl();
        if (StringUtils.isEmpty((String)targetUrl)) {
            targetUrl = this.getFormTemplate();
        }
        task.setUrl(context.getExpressionContext().evalString(processInstance, targetUrl));
        return task;
    }

    public DueDefinition getCustomDueDefinition(ProcessInstance processInstance, Task task, ApplicationContext applicationContext) {
        Collection colls = applicationContext.getBeansOfType(TaskDueDefinitionProvider.class).values();
        if (colls.size() == 0) {
            return null;
        }
        return ((TaskDueDefinitionProvider)colls.iterator().next()).getDueDefinition(task, processInstance);
    }

    private Date createReminder(ProcessInstance processInstance, Task task, Context context) {
        TaskReminder dueActionReminder;
        Reminder reminder = null;
        DueDefinition dueDef = this.getCustomDueDefinition(processInstance, task, context.getApplicationContext());
        Date startReminderDate = null;
        if (dueDef != null) {
            reminder = dueDef.getReminder();
            startReminderDate = this.computeDueReminderStartdate(context, dueDef);
        } else {
            if (this.dueDefinition == null) {
                return null;
            }
            startReminderDate = this.computeDueReminderStartdate(context, this.dueDefinition);
            reminder = this.dueDefinition.getReminder();
        }
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        if (reminder != null) {
            ReminderType type = ReminderType.Once;
            String cron = null;
            if (reminder instanceof PeriodReminder) {
                type = ReminderType.Period;
                PeriodReminder period = (PeriodReminder)reminder;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(startReminderDate);
                DateUnit unit = period.getUnit();
                int sec = calendar.get(13);
                int min = calendar.get(12);
                int hour = calendar.get(10);
                if (unit.equals((Object)DateUnit.Minute)) {
                    cron = "" + sec + " 0/" + period.getRepeat() + " * ? * *";
                } else if (unit.equals((Object)DateUnit.Hour)) {
                    cron = "" + sec + " " + min + " 0/" + period.getRepeat() + " ? * *";
                } else if (unit.equals((Object)DateUnit.Day)) {
                    cron = "" + sec + " " + min + " " + hour + " 1/" + period.getRepeat() + " * ?";
                } else {
                    throw new IllegalArgumentException("Unsupport date unit :" + (Object)((Object)unit));
                }
            }
            TaskReminder taskReminder = new TaskReminder();
            taskReminder.setId(IDGenerator.getInstance().nextId());
            taskReminder.setTaskId(task.getId());
            taskReminder.setTaskNodeName(this.getName());
            taskReminder.setProcessId(processInstance.getProcessId());
            taskReminder.setReminderHandlerBean(reminder.getHandlerBean());
            taskReminder.setType(type);
            taskReminder.setStartDate(startReminderDate);
            taskReminder.setCron(cron);
            schedulerService.addReminderJob(taskReminder, processInstance, task);
            context.getSession().save((Object)taskReminder);
        }
        if ((dueActionReminder = this.buildDueAction(dueDef, startReminderDate, context, task)) != null) {
            schedulerService.addReminderJob(dueActionReminder, processInstance, task);
            context.getSession().save((Object)dueActionReminder);
        }
        return startReminderDate;
    }

    private TaskReminder buildDueAction(DueDefinition dueDef, Date startReminderDate, Context context, Task task) {
        DueAction dueAction = null;
        if (dueDef != null) {
            dueAction = dueDef.getDueAction();
        } else {
            if (this.dueDefinition == null) {
                return null;
            }
            dueAction = this.dueDefinition.getDueAction();
        }
        if (dueAction == null || dueAction.getHandlerBean() == null) {
            return null;
        }
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(startReminderDate);
        int day = dueAction.getDay();
        int hour = dueAction.getHour();
        int minute = dueAction.getMinute();
        BusinessCalendar businessCalendar = (BusinessCalendar)context.getApplicationContext().getBean("uflo.businessCalendar");
        int businessDayHours = businessCalendar.getBusinessDayHours();
        if (dueDef != null && dueDef.getBusinessDayHours() > 0) {
            businessDayHours = dueDef.getBusinessDayHours();
        }
        if (day > 0) {
            endCalendar.add(11, day * businessDayHours);
        }
        if (hour > 0) {
            endCalendar.add(11, hour);
        }
        if (minute > 0) {
            endCalendar.add(12, minute);
        }
        List<CalendarInfo> infos = dueAction.getCalendarInfos();
        Date executeActionDate = null;
        if (infos != null && infos.size() > 0) {
            Calendar startCalendar = Calendar.getInstance();
            SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
            startCalendar.setTime(startReminderDate);
            org.quartz.Calendar baseCalendar = schedulerService.buildCalendar(infos);
            executeActionDate = businessCalendar.calEndDate(startCalendar, endCalendar, baseCalendar);
        } else {
            executeActionDate = endCalendar.getTime();
        }
        TaskReminder taskReminder = new TaskReminder();
        taskReminder.setId(IDGenerator.getInstance().nextId());
        taskReminder.setTaskId(task.getId());
        taskReminder.setTaskNodeName(this.getName());
        taskReminder.setProcessId(task.getProcessId());
        taskReminder.setReminderHandlerBean(dueAction.getHandlerBean());
        taskReminder.setType(ReminderType.Once);
        taskReminder.setStartDate(executeActionDate);
        task.setDueActionDate(executeActionDate);
        return taskReminder;
    }

    private Date computeDueReminderStartdate(Context context, DueDefinition dueDef) {
        List<CalendarInfo> infos;
        if (dueDef == null) {
            return null;
        }
        int dueDay = dueDef.getDay();
        int dueHour = dueDef.getHour();
        int dueMinute = dueDef.getMinute();
        Calendar endCalendar = Calendar.getInstance();
        BusinessCalendar businessCalendar = (BusinessCalendar)context.getApplicationContext().getBean("uflo.businessCalendar");
        int businessDayHours = businessCalendar.getBusinessDayHours();
        if (dueDef.getBusinessDayHours() > 0) {
            businessDayHours = dueDef.getBusinessDayHours();
        }
        if (dueDay > 0) {
            endCalendar.add(11, dueDay * businessDayHours);
        }
        if (dueHour > 0) {
            endCalendar.add(11, dueHour);
        }
        if (dueMinute > 0) {
            endCalendar.add(12, dueMinute);
        }
        if ((infos = dueDef.getCalendarInfos()) != null && infos.size() > 0) {
            Calendar startCalendar = Calendar.getInstance();
            SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
            org.quartz.Calendar baseCalendar = schedulerService.buildCalendar(infos);
            return businessCalendar.calEndDate(startCalendar, endCalendar, baseCalendar);
        }
        return endCalendar.getTime();
    }

    public static Date computeFireTimesWithStart(OperableTrigger trigg, org.quartz.Calendar cal, Date from) {
        OperableTrigger t = (OperableTrigger)trigg.clone();
        if (t.getNextFireTime() == null) {
            t.setStartTime(from);
            t.computeFirstFireTime(cal);
        }
        return t.getNextFireTime();
    }

    private void processAssignees(Context context, ProcessInstance processInstance, List<Assignee> assigneeList) {
        ArrayList<String> users = new ArrayList<String>();
        this.retriveAssignees(assigneeList, context, processInstance, users);
        this.createTasks(context, processInstance, users);
    }

    private void retriveAssignees(List<Assignee> assigneeList, Context context, ProcessInstance processInstance, List<String> users) {
        ApplicationContext applicationContext = context.getApplicationContext();
        for (Assignee assignee : assigneeList) {
            AssigneeProvider provider = (AssigneeProvider)applicationContext.getBean(assignee.getProviderId());
            Collection<String> coll = provider.getUsers(assignee.getId(), context, processInstance);
            if (coll == null || coll.size() <= 0) continue;
            users.addAll(coll);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized String leave(Context context, ProcessInstance processInstance, String flowName) {
        if (this.taskType.equals((Object)TaskType.Countersign)) {
            TaskQuery query = context.getTaskService().createTaskQuery();
            query.addTaskState(TaskState.Created).addTaskState(TaskState.Ready).addTaskState(TaskState.Suspended).addTaskState(TaskState.InProgress).addTaskState(TaskState.Reserved);
            query.processInstanceId(processInstance.getId());
            List countersignTasks = (List)query.list();
            if (countersignTasks.size() > 0) {
                Task task = (Task)countersignTasks.get(0);
                int alreadyCompletedCount = task.getCountersignCount() - countersignTasks.size();
                if (this.countersignMultiplicity > 0) {
                    if (alreadyCompletedCount < this.countersignMultiplicity) return null;
                    this.cancelTasks(context, processInstance, countersignTasks);
                } else if (this.countersignPercentMultiplicity > 0) {
                    double percent = Double.valueOf(this.countersignPercentMultiplicity) / Double.valueOf(100.0);
                    double alreadyCompletedPercent = Double.valueOf(alreadyCompletedCount) / Double.valueOf(task.getCountersignCount());
                    if (!(alreadyCompletedPercent >= percent)) return null;
                    this.cancelTasks(context, processInstance, countersignTasks);
                } else if (StringUtils.isNotEmpty((String)this.countersignExpression)) {
                    Object obj = context.getExpressionContext().eval(processInstance.getId(), this.countersignExpression);
                    if (!(obj instanceof Boolean)) {
                        throw new IllegalArgumentException(this.getName() + " countersign task expression " + this.countersignExpression + " value type must be is boolean,current is " + obj + "");
                    }
                    boolean result = (Boolean)obj;
                    if (!result) return null;
                    this.cancelTasks(context, processInstance, countersignTasks);
                } else if (StringUtils.isNotEmpty((String)this.countersignHandler)) {
                    CountersignHandler handler = (CountersignHandler)context.getApplicationContext().getBean(this.countersignHandler);
                    if (!handler.handle(context, processInstance)) return null;
                    this.cancelTasks(context, processInstance, countersignTasks);
                } else if (alreadyCompletedCount < task.getCountersignCount()) {
                    return null;
                }
            }
        }
        if (!StringUtils.isNotEmpty((String)flowName)) return this.leaveNode(context, processInstance, flowName);
        SequenceFlowImpl flow = this.getFlow(flowName);
        if (flow == null) {
            throw new IllegalArgumentException("Flow " + flowName + " is not exist!");
        }
        flow.execute(context, processInstance);
        return flow.getName();
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
        Session session = context.getSession();
        List tasks = session.createCriteria(Task.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)processInstance.getId())).list();
        this.cancelTasks(context, processInstance, tasks);
    }

    private void cancelTasks(Context context, ProcessInstance processInstance, Collection<Task> tasks) {
        Session session = context.getSession();
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        Collection interceptors = context.getApplicationContext().getBeansOfType(CancelTaskInterceptor.class).values();
        for (Task task : tasks) {
            for (CancelTaskInterceptor interceptor : interceptors) {
                interceptor.intercept(context, task);
            }
            if (this.dueDefinition != null) {
                schedulerService.removeReminderJob(task);
            }
            task.setState(TaskState.Canceled);
            session.update((Object)task);
            context.getCommandService().executeCommand(new SaveHistoryTaskCommand(task, processInstance));
        }
    }

    public Authority getComponentAuthority(String component) {
        if (this.componentAuthorities == null || this.componentAuthorities.size() == 0) {
            return Authority.ReadAndWrite;
        }
        boolean read = false;
        boolean write = false;
        for (ComponentAuthority componentAuthority : this.componentAuthorities) {
            if (!component.equals(componentAuthority.getComponent())) continue;
            if (componentAuthority.getAuthority().equals((Object)Authority.Read)) {
                read = true;
                continue;
            }
            if (!componentAuthority.getAuthority().equals((Object)Authority.ReadAndWrite)) continue;
            read = true;
            write = true;
            break;
        }
        if (read && write) {
            return Authority.ReadAndWrite;
        }
        if (read) {
            return Authority.Read;
        }
        return null;
    }

    @Override
    public NodeType getType() {
        if (this.taskType.equals((Object)TaskType.Countersign)) {
            return NodeType.CountersignTask;
        }
        return NodeType.Task;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFormTemplate() {
        return this.formTemplate;
    }

    public void setFormTemplate(String formTemplate) {
        this.formTemplate = formTemplate;
    }

    public AssignmentType getAssignmentType() {
        return this.assignmentType;
    }

    public void setAssignmentType(AssignmentType assignmentType) {
        this.assignmentType = assignmentType;
    }

    public int getCountersignMultiplicity() {
        return this.countersignMultiplicity;
    }

    public void setCountersignMultiplicity(int countersignMultiplicity) {
        this.countersignMultiplicity = countersignMultiplicity;
    }

    public int getCountersignPercentMultiplicity() {
        return this.countersignPercentMultiplicity;
    }

    public void setCountersignPercentMultiplicity(int countersignPercentMultiplicity) {
        this.countersignPercentMultiplicity = countersignPercentMultiplicity;
    }

    public String getCountersignExpression() {
        return this.countersignExpression;
    }

    public void setCountersignExpression(String countersignExpression) {
        this.countersignExpression = countersignExpression;
    }

    public String getCountersignHandler() {
        return this.countersignHandler;
    }

    public void setCountersignHandler(String countersignHandler) {
        this.countersignHandler = countersignHandler;
    }

    public String getAssignmentHandlerBean() {
        return this.assignmentHandlerBean;
    }

    public void setAssignmentHandlerBean(String assignmentHandlerBean) {
        this.assignmentHandlerBean = assignmentHandlerBean;
    }

    public List<Assignee> getAssignees() {
        return this.assignees;
    }

    public void setAssignees(List<Assignee> assignees) {
        this.assignees = assignees;
    }

    public String getSwimlane() {
        return this.swimlane;
    }

    public void setSwimlane(String swimlane) {
        this.swimlane = swimlane;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public List<ComponentAuthority> getComponentAuthorities() {
        return this.componentAuthorities;
    }

    public void setComponentAuthorities(List<ComponentAuthority> componentAuthorities) {
        this.componentAuthorities = componentAuthorities;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public DueDefinition getDueDefinition() {
        return this.dueDefinition;
    }

    public void setDueDefinition(DueDefinition reminderDefinition) {
        this.dueDefinition = reminderDefinition;
    }

    public boolean isAllowSpecifyAssignee() {
        return this.allowSpecifyAssignee;
    }

    public void setAllowSpecifyAssignee(boolean allowSpecifyAssignee) {
        this.allowSpecifyAssignee = allowSpecifyAssignee;
    }

    public List<FormElement> getFormElements() {
        return this.formElements;
    }

    public void setFormElements(List<FormElement> formElements) {
        this.formElements = formElements;
    }

    public List<UserData> getUserData() {
        return this.userData;
    }

    public void setUserData(List<UserData> userData) {
        this.userData = userData;
    }

    public String getTaskListenerBean() {
        return this.taskListenerBean;
    }

    public void setTaskListenerBean(String taskListenerBean) {
        this.taskListenerBean = taskListenerBean;
    }

    private Collection<GlobalTaskListener> fetchGlobalTaskListener(Context context) {
        return context.getApplicationContext().getBeansOfType(GlobalTaskListener.class).values();
    }
}

