/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.command.impl.StartProcessInstanceCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.process.node.SubprocessType;
import com.bstek.uflo.process.node.SubprocessVariable;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.StartProcessInfo;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SubprocessNode
extends Node {
    private static final long serialVersionUID = -8435682801132645374L;
    private static final Log log = LogFactory.getLog(SubprocessNode.class);
    private boolean completeStartTask = true;
    private SubprocessType subprocessType;
    private String subprocessName;
    private String subprocessKey;
    private String subprocessId;
    private List<SubprocessVariable> inVariables;
    private List<SubprocessVariable> outVariables;

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        ProcessService processService = context.getProcessService();
        ProcessDefinition subprocess = this.getTargetSubprocess(processService);
        HashMap<String, Object> variables = null;
        if (this.inVariables != null && this.inVariables.size() > 0) {
            variables = new HashMap<String, Object>();
            for (SubprocessVariable var : this.inVariables) {
                Object obj = processService.getProcessVariable(var.getInParameterKey(), processInstance);
                variables.put(var.getOutParameterKey(), obj);
            }
        }
        StartProcessInfo startProcessInfo = new StartProcessInfo(processInstance.getPromoter());
        startProcessInfo.setBusinessId(processInstance.getBusinessId());
        startProcessInfo.setSubject(processInstance.getSubject());
        startProcessInfo.setPromoter(processInstance.getPromoter());
        startProcessInfo.setTag(processInstance.getTag());
        startProcessInfo.setCompleteStartTask(this.completeStartTask);
        context.getCommandService().executeCommand(new StartProcessInstanceCommand(subprocess, variables, startProcessInfo, processInstance.getId()));
        return false;
    }

    @Override
    public String leave(Context context, ProcessInstance processInstance, String flowName) {
        SequenceFlowImpl targetFlow = null;
        if (StringUtils.isNotEmpty((String)flowName)) {
            targetFlow = this.getFlow(flowName);
            if (targetFlow == null) {
                throw new IllegalArgumentException("Flow " + flowName + " is not exist!");
            }
        } else {
            targetFlow = this.getSequenceFlows().get(0);
        }
        targetFlow.execute(context, processInstance);
        return targetFlow.getName();
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
        ProcessService processService = context.getProcessService();
        ProcessDefinition subprocess = this.getTargetSubprocess(processService);
        if (subprocess == null) {
            log.error((Object)"SubprocessNode must be specify subprocessKey/subprocessId or subprocessName at least one");
            return;
        }
        List subinstances = context.getSession().createCriteria(ProcessInstance.class).add((Criterion)Restrictions.eq((String)"parentId", (Object)processInstance.getId())).add((Criterion)Restrictions.eq((String)"processId", (Object)subprocess.getId())).list();
        for (ProcessInstance pi : subinstances) {
            processService.deleteProcessInstance(pi);
        }
    }

    private ProcessDefinition getTargetSubprocess(ProcessService processService) {
        ProcessDefinition subprocess = null;
        if (this.subprocessType.equals((Object)SubprocessType.Id)) {
            if (StringUtils.isEmpty((String)this.subprocessId)) {
                throw new IllegalArgumentException("Subprocess type is Id,so subprocess id can not be null.");
            }
            subprocess = processService.getProcessById(Long.valueOf(this.subprocessId));
        } else if (this.subprocessType.equals((Object)SubprocessType.Key)) {
            if (StringUtils.isEmpty((String)this.subprocessKey)) {
                throw new IllegalArgumentException("Subprocess type is Key,so subprocess key can not be null.");
            }
            subprocess = processService.getProcessByKey(this.subprocessKey);
        } else {
            if (StringUtils.isEmpty((String)this.subprocessName)) {
                throw new IllegalArgumentException("Subprocess type is Name,so subprocess name can not be null.");
            }
            subprocess = processService.getProcessByName(this.subprocessName);
        }
        return subprocess;
    }

    @Override
    public NodeType getType() {
        return NodeType.Subprocess;
    }

    public SubprocessType getSubprocessType() {
        return this.subprocessType;
    }

    public void setSubprocessType(SubprocessType subprocessType) {
        this.subprocessType = subprocessType;
    }

    public String getSubprocessName() {
        return this.subprocessName;
    }

    public void setSubprocessName(String subprocessName) {
        this.subprocessName = subprocessName;
    }

    public String getSubprocessKey() {
        return this.subprocessKey;
    }

    public void setSubprocessKey(String subprocessKey) {
        this.subprocessKey = subprocessKey;
    }

    public List<SubprocessVariable> getInVariables() {
        return this.inVariables;
    }

    public void setInVariables(List<SubprocessVariable> inVariables) {
        this.inVariables = inVariables;
    }

    public List<SubprocessVariable> getOutVariables() {
        return this.outVariables;
    }

    public void setOutVariables(List<SubprocessVariable> outVariables) {
        this.outVariables = outVariables;
    }

    public String getSubprocessId() {
        return this.subprocessId;
    }

    public void setSubprocessId(String subprocessId) {
        this.subprocessId = subprocessId;
    }

    public void setCompleteStartTask(boolean completeStartTask) {
        this.completeStartTask = completeStartTask;
    }

    public boolean isCompleteStartTask() {
        return this.completeStartTask;
    }
}

