/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.command.impl.SaveHistoryTaskCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.CancelTaskInterceptor;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.process.node.FormElement;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.process.security.ComponentAuthority;
import com.bstek.uflo.service.StartProcessInfo;
import com.bstek.uflo.utils.IDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class StartNode
extends Node {
    private static final long serialVersionUID = 3876654522900406746L;
    private String taskName;
    private String url;
    private String formTemplate;
    private List<FormElement> formElements;
    private List<ComponentAuthority> componentAuthorities;

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        StartProcessInfo startProcessInfo = (StartProcessInfo)processInstance.getMetadata(StartProcessInfo.KEY);
        Task task = new Task();
        task.setId(IDGenerator.getInstance().nextId());
        task.setNodeName(this.getName());
        if (StringUtils.isEmpty((String)this.taskName)) {
            this.taskName = this.getName();
        }
        task.setRootProcessInstanceId(processInstance.getRootId());
        task.setTaskName(context.getExpressionContext().evalString(processInstance, this.taskName));
        task.setDescription(this.getDescription());
        task.setCreateDate(new Date());
        task.setProcessId(this.getProcessId());
        task.setProcessInstanceId(processInstance.getId());
        task.setPrevTask(processInstance.getCurrentTask());
        task.setBusinessId(processInstance.getBusinessId());
        String targetUrl = this.getUrl();
        if (StringUtils.isEmpty((String)targetUrl)) {
            targetUrl = this.getFormTemplate();
        }
        task.setUrl(context.getExpressionContext().evalString(processInstance, targetUrl));
        task.setType(TaskType.Normal);
        if (startProcessInfo != null) {
            task.setOwner(startProcessInfo.getPromoter());
            task.setSubject(startProcessInfo.getSubject());
            task.setAssignee(startProcessInfo.getPromoter());
            if (startProcessInfo.isCompleteStartTask()) {
                task.setState(TaskState.Completed);
                task.setOpinion(startProcessInfo.getCompleteStartTaskOpinion());
                context.getCommandService().executeCommand(new SaveHistoryTaskCommand(task, processInstance));
                return true;
            }
        } else {
            task.setOwner(processInstance.getPromoter());
            task.setAssignee(processInstance.getPromoter());
            task.setSubject(processInstance.getSubject());
        }
        task.setState(TaskState.Created);
        context.getSession().save((Object)task);
        return false;
    }

    @Override
    public String leave(Context context, ProcessInstance processInstance, String flowName) {
        return this.leaveNode(context, processInstance, flowName);
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
        Session session = context.getSession();
        List tasks = session.createCriteria(Task.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)processInstance.getId())).list();
        this.cancelTasks(context, processInstance, tasks);
    }

    private void cancelTasks(Context context, ProcessInstance processInstance, Collection<Task> tasks) {
        Session session = context.getSession();
        Collection interceptors = context.getApplicationContext().getBeansOfType(CancelTaskInterceptor.class).values();
        for (Task task : tasks) {
            for (CancelTaskInterceptor interceptor : interceptors) {
                interceptor.intercept(context, task);
            }
            session.delete((Object)task);
            task.setState(TaskState.Canceled);
            context.getCommandService().executeCommand(new SaveHistoryTaskCommand(task, processInstance));
        }
    }

    @Override
    public NodeType getType() {
        return NodeType.Start;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<FormElement> getFormElements() {
        return this.formElements;
    }

    public void setFormElements(List<FormElement> formElements) {
        this.formElements = formElements;
    }

    public String getFormTemplate() {
        return this.formTemplate;
    }

    public void setFormTemplate(String formTemplate) {
        this.formTemplate = formTemplate;
    }

    public List<ComponentAuthority> getComponentAuthorities() {
        return this.componentAuthorities;
    }

    public void setComponentAuthorities(List<ComponentAuthority> componentAuthorities) {
        this.componentAuthorities = componentAuthorities;
    }
}

