/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.command.impl.SaveHistoryActivityCommand;
import com.bstek.uflo.diagram.NodeDiagram;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryActivity;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.handler.NodeEventHandler;
import com.bstek.uflo.process.node.NodeType;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class Node
implements Serializable {
    private static final long serialVersionUID = -7347322856264296067L;
    private String name;
    private String label;
    private String description;
    private long processId;
    private NodeDiagram diagram;
    private List<SequenceFlowImpl> sequenceFlows;
    private String eventHandlerBean;
    private int x;
    private int y;
    private int width;
    private int height;

    public abstract boolean enter(Context var1, ProcessInstance var2);

    public abstract void cancel(Context var1, ProcessInstance var2);

    public abstract String leave(Context var1, ProcessInstance var2, String var3);

    private HistoryActivity saveActivityHistory(Context context, ProcessInstance processInstance, boolean isEnd, String leaveFlowName) {
        return context.getCommandService().executeCommand(new SaveHistoryActivityCommand(processInstance, this, isEnd, leaveFlowName));
    }

    public HistoryActivity createActivityHistory(Context context, ProcessInstance processInstance) {
        return this.saveActivityHistory(context, processInstance, false, null);
    }

    public HistoryActivity completeActivityHistory(Context context, ProcessInstance processInstance, String flowName) {
        return this.saveActivityHistory(context, processInstance, true, flowName);
    }

    protected String leaveNode(Context context, ProcessInstance processInstance, String flowName) {
        if (StringUtils.isNotEmpty((String)flowName)) {
            SequenceFlowImpl flow = this.getFlow(flowName);
            if (flow == null) {
                throw new IllegalArgumentException("Sequence flow [" + flowName + "] not exist!");
            }
            flow.execute(context, processInstance);
            return flow.getName();
        }
        for (SequenceFlowImpl flow : this.sequenceFlows) {
            if (!flow.canExecute(context, processInstance)) continue;
            flow.execute(context, processInstance);
            return flow.getName();
        }
        throw new IllegalArgumentException("All the sequence flow can not be perform!");
    }

    private void executeEventHandler(Context context, ProcessInstance processInstance, boolean enter) {
        if (StringUtils.isNotEmpty((String)this.eventHandlerBean)) {
            NodeEventHandler handler = (NodeEventHandler)context.getApplicationContext().getBean(this.eventHandlerBean);
            if (enter) {
                handler.enter(this, processInstance, context);
            } else {
                handler.leave(this, processInstance, context);
            }
        }
    }

    public void doEnterEventHandler(Context context, ProcessInstance processInstance) {
        this.executeEventHandler(context, processInstance, true);
    }

    public void doLeaveEventHandler(Context context, ProcessInstance processInstance) {
        this.executeEventHandler(context, processInstance, false);
    }

    protected SequenceFlowImpl getFlow(String flowName) {
        SequenceFlowImpl flow = null;
        for (SequenceFlowImpl f : this.getSequenceFlows()) {
            String name = f.getName();
            if (!flowName.equals(name)) continue;
            flow = f;
            break;
        }
        return flow;
    }

    public abstract NodeType getType();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public NodeDiagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(NodeDiagram diagram) {
        this.diagram = diagram;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SequenceFlowImpl> getSequenceFlows() {
        return this.sequenceFlows;
    }

    public void setSequenceFlows(List<SequenceFlowImpl> sequenceFlows) {
        this.sequenceFlows = sequenceFlows;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public String getEventHandlerBean() {
        return this.eventHandlerBean;
    }

    public void setEventHandlerBean(String eventHandlerBean) {
        this.eventHandlerBean = eventHandlerBean;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

