/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.env.Context;
import com.bstek.uflo.expr.ExpressionContext;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.query.ProcessVariableQuery;
import com.bstek.uflo.service.ProcessService;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class JoinNode
extends Node {
    private static final long serialVersionUID = 6808697583212585654L;
    private int multiplicity;
    private int percentMultiplicity;

    @Override
    public synchronized boolean enter(Context context, ProcessInstance processInstance) {
        Session session = context.getSession();
        processInstance.setState(ProcessInstanceState.End);
        ProcessService processService = context.getProcessService();
        ExpressionContext expressionContext = context.getExpressionContext();
        expressionContext.moveContextToParent(processInstance);
        expressionContext.removeContext(processInstance);
        long parentId = processInstance.getParentId();
        ProcessInstance parentProcessInstance = processService.getProcessInstanceById(parentId);
        this.createActivityHistory(context, parentProcessInstance);
        this.doEnterEventHandler(context, parentProcessInstance);
        ProcessVariableQuery query = processService.createProcessVariableQuery();
        query.processInstanceId(processInstance.getId());
        for (Variable var : (List)query.list()) {
            var.setProcessInstanceId(parentId);
            session.update((Object)var);
        }
        session.delete((Object)processInstance);
        List noneCompleteProcessInstances = session.createCriteria(ProcessInstance.class).add((Criterion)Restrictions.eq((String)"parentId", (Object)parentId)).list();
        int parallelCount = processInstance.getParallelInstanceCount();
        int completedCount = parallelCount - noneCompleteProcessInstances.size();
        ProcessDefinition pd = processService.getProcessById(processInstance.getProcessId());
        if (this.multiplicity > 0) {
            if (completedCount >= this.multiplicity) {
                for (ProcessInstance pi : noneCompleteProcessInstances) {
                    Node node = pd.getNode(pi.getCurrentNode());
                    node.cancel(context, processInstance);
                    session.createQuery("delete " + Variable.class.getName() + " where processInstanceId=:piId").setLong("piId", pi.getId()).executeUpdate();
                    processService.deleteProcessInstance(pi);
                    node.completeActivityHistory(context, pi, null);
                    expressionContext.removeContext(pi);
                }
                return true;
            }
        } else if (this.percentMultiplicity > 0) {
            double percent = Double.valueOf(this.percentMultiplicity) / Double.valueOf(100.0);
            double alreadyCompletedPercent = Double.valueOf(completedCount) / Double.valueOf(parallelCount);
            if (alreadyCompletedPercent >= percent) {
                for (ProcessInstance pi : noneCompleteProcessInstances) {
                    Node node = pd.getNode(pi.getCurrentNode());
                    node.cancel(context, pi);
                    session.createQuery("delete " + Variable.class.getName() + " where processInstanceId=:piId").setLong("piId", pi.getId()).executeUpdate();
                    processService.deleteProcessInstance(pi);
                    node.completeActivityHistory(context, pi, null);
                    expressionContext.removeContext(pi);
                }
                return true;
            }
        } else if (noneCompleteProcessInstances.size() == 0) {
            return true;
        }
        return false;
    }

    @Override
    public String leave(Context context, ProcessInstance processInstance, String flowName) {
        Session session = context.getSession();
        long parentProcessInstanceId = processInstance.getParentId();
        ProcessInstance parentProcessInstance = (ProcessInstance)session.createCriteria(ProcessInstance.class).add((Criterion)Restrictions.eq((String)"id", (Object)parentProcessInstanceId)).uniqueResult();
        ProcessDefinition pd = context.getProcessService().getProcessById(processInstance.getProcessId());
        Node node = pd.getNode(parentProcessInstance.getCurrentNode());
        node.doLeaveEventHandler(context, parentProcessInstance);
        node.completeActivityHistory(context, parentProcessInstance, flowName);
        parentProcessInstance.setCurrentNode(this.getName());
        return this.leaveNode(context, parentProcessInstance, flowName);
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
    }

    @Override
    public NodeType getType() {
        return NodeType.Join;
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(int multiplicity) {
        this.multiplicity = multiplicity;
    }

    public int getPercentMultiplicity() {
        return this.percentMultiplicity;
    }

    public void setPercentMultiplicity(int percentMultiplicity) {
        this.percentMultiplicity = percentMultiplicity;
    }
}

