/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.utils.IDGenerator;
import java.util.ArrayList;
import java.util.Date;
import org.hibernate.Session;

public class ForkNode
extends Node {
    private static final long serialVersionUID = -1654058426879715199L;

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        return true;
    }

    @Override
    public String leave(Context context, ProcessInstance processInstance, String flowName) {
        Session session = context.getSession();
        ArrayList<SequenceFlowImpl> flows = new ArrayList<SequenceFlowImpl>();
        for (SequenceFlowImpl flow : this.getSequenceFlows()) {
            if (!flow.canExecute(context, processInstance)) continue;
            flows.add(flow);
        }
        for (SequenceFlowImpl flow : flows) {
            ProcessInstance subProcessInstance = new ProcessInstance();
            subProcessInstance.setId(IDGenerator.getInstance().nextId());
            subProcessInstance.setProcessId(this.getProcessId());
            subProcessInstance.setParentId(processInstance.getId());
            subProcessInstance.setCreateDate(new Date());
            subProcessInstance.setState(ProcessInstanceState.Start);
            subProcessInstance.setRootId(processInstance.getRootId());
            subProcessInstance.setParallelInstanceCount(flows.size());
            subProcessInstance.setPromoter(processInstance.getPromoter());
            subProcessInstance.setHistoryProcessInstanceId(processInstance.getHistoryProcessInstanceId());
            subProcessInstance.setCurrentTask(processInstance.getCurrentTask());
            subProcessInstance.setBusinessId(processInstance.getBusinessId());
            subProcessInstance.setTag(processInstance.getTag());
            subProcessInstance.setSubject(processInstance.getSubject());
            session.save((Object)subProcessInstance);
            context.getExpressionContext().createContext(subProcessInstance, null);
            flow.execute(context, subProcessInstance);
            flowName = flow.getName();
        }
        return flowName;
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
    }

    @Override
    public NodeType getType() {
        return NodeType.Fork;
    }
}

