/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.command.impl.SaveProcessInstanceVariablesCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import com.bstek.uflo.process.handler.ForeachHandler;
import com.bstek.uflo.process.node.ForeachType;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.utils.IDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class ForeachNode
extends Node {
    private static final long serialVersionUID = -7072013520247348803L;
    private String variable;
    private ForeachType foreachType;
    private String processVariable;
    private String handlerBean;

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        Collection coll = null;
        if (StringUtils.isEmpty((String)this.variable)) {
            throw new IllegalArgumentException("ForeachNode var property can not be null");
        }
        if (this.foreachType.equals((Object)ForeachType.Handler)) {
            ForeachHandler handler = (ForeachHandler)context.getApplicationContext().getBean(this.handlerBean);
            coll = handler.handle(processInstance, context);
            if (coll == null || coll.size() == 0) {
                throw new IllegalArgumentException("ForeachNode [" + this.handlerBean + "] return value is invalid!");
            }
        } else {
            if (StringUtils.isEmpty((String)this.processVariable)) {
                throw new IllegalArgumentException("ForeachNode processVariable property can not be null");
            }
            Object variableObj = context.getExpressionContext().eval(processInstance, this.processVariable);
            if (variableObj instanceof Object[]) {
                Object[] objs;
                coll = new ArrayList<Object>();
                for (Object obj : objs = (Object[])variableObj) {
                    coll.add(obj);
                }
            } else if (variableObj instanceof Collection) {
                coll = (Collection)variableObj;
            } else {
                throw new IllegalArgumentException("ForeachHandler [" + this.processVariable + "] return value type must be a collection or a array!");
            }
        }
        this.createSubprocessInstance(context, processInstance, coll);
        return false;
    }

    private void createSubprocessInstance(Context context, ProcessInstance processInstance, Collection<Object> coll) {
        for (Object obj : coll) {
            ProcessInstance subProcessInstance = new ProcessInstance();
            subProcessInstance.setId(IDGenerator.getInstance().nextId());
            subProcessInstance.setProcessId(this.getProcessId());
            subProcessInstance.setParentId(processInstance.getId());
            subProcessInstance.setCreateDate(new Date());
            subProcessInstance.setState(ProcessInstanceState.Start);
            subProcessInstance.setRootId(processInstance.getRootId());
            subProcessInstance.setParallelInstanceCount(coll.size());
            subProcessInstance.setPromoter(processInstance.getPromoter());
            subProcessInstance.setHistoryProcessInstanceId(processInstance.getHistoryProcessInstanceId());
            subProcessInstance.setCurrentTask(processInstance.getCurrentTask());
            subProcessInstance.setBusinessId(processInstance.getBusinessId());
            subProcessInstance.setTag(processInstance.getTag());
            subProcessInstance.setSubject(processInstance.getSubject());
            context.getSession().save((Object)subProcessInstance);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put(this.variable, obj);
            context.getCommandService().executeCommand(new SaveProcessInstanceVariablesCommand(subProcessInstance, variables));
            context.getExpressionContext().createContext(subProcessInstance, variables);
            this.getSequenceFlows().get(0).execute(context, subProcessInstance);
        }
    }

    @Override
    public String leave(Context context, ProcessInstance processInstance, String flowName) {
        return null;
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
    }

    @Override
    public NodeType getType() {
        return NodeType.Foreach;
    }

    public ForeachType getForeachType() {
        return this.foreachType;
    }

    public void setForeachType(ForeachType foreachType) {
        this.foreachType = foreachType;
    }

    public String getProcessVariable() {
        return this.processVariable;
    }

    public void setProcessVariable(String processVariable) {
        this.processVariable = processVariable;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getHandlerBean() {
        return this.handlerBean;
    }

    public void setHandlerBean(String handlerBean) {
        this.handlerBean = handlerBean;
    }
}

