/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.command.impl.SaveHistoryProcessInstanceCommand;
import com.bstek.uflo.command.impl.SaveProcessInstanceVariablesCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryBlob;
import com.bstek.uflo.model.HistoryVariable;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskParticipator;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.model.variable.BlobVariable;
import com.bstek.uflo.model.variable.DateVariable;
import com.bstek.uflo.model.variable.TextVariable;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.process.handler.ProcessEventHandler;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import com.bstek.uflo.process.node.SubprocessNode;
import com.bstek.uflo.process.node.SubprocessVariable;
import com.bstek.uflo.query.impl.ProcessVariableQueryImpl;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.utils.ProcessListenerUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class EndNode
extends Node {
    private static final long serialVersionUID = 3694427904622957142L;
    private boolean terminate = true;

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
    }

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        return true;
    }

    @Override
    public synchronized String leave(Context context, ProcessInstance processInstance, String flowName) {
        Session session = context.getSession();
        ProcessService processService = context.getProcessService();
        ProcessDefinition process = processService.getProcessById(processInstance.getProcessId());
        boolean isRootProcessInstance = processInstance.getId() == processInstance.getRootId();
        List children = session.createCriteria(ProcessInstance.class).add((Criterion)Restrictions.eq((String)"rootId", (Object)processInstance.getRootId())).list();
        if (isRootProcessInstance) {
            ProcessListenerUtils.fireProcessEndListers(processInstance, context);
            this.completeProcessInstance(context, process, processInstance, processInstance, children);
        } else if (this.isTerminate()) {
            ProcessInstance rootProcessInstance = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)Long.valueOf(processInstance.getRootId()));
            ProcessListenerUtils.fireProcessEndListers(rootProcessInstance, context);
            this.completeProcessInstance(context, process, processInstance, rootProcessInstance, children);
        } else if (children.size() == 1) {
            ProcessInstance rootProcessInstance = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)Long.valueOf(processInstance.getRootId()));
            ProcessListenerUtils.fireProcessEndListers(rootProcessInstance, context);
            this.completeProcessInstance(context, process, processInstance, rootProcessInstance, children);
        } else {
            this.doLeaveEventHandler(context, processInstance);
            this.completeActivityHistory(context, processInstance, null);
            session.delete((Object)processInstance);
            context.getExpressionContext().removeContext(processInstance);
        }
        return null;
    }

    private void completeProcessInstance(Context context, ProcessDefinition process, ProcessInstance processInstance, ProcessInstance rootProcessInstance, List<ProcessInstance> children) {
        this.doLeaveEventHandler(context, processInstance);
        this.completeActivityHistory(context, processInstance, null);
        String processEventHandlerBean = process.getEventHandlerBean();
        if (StringUtils.isNotEmpty((String)processEventHandlerBean)) {
            ProcessEventHandler bean = (ProcessEventHandler)context.getApplicationContext().getBean(processEventHandlerBean);
            bean.end(rootProcessInstance, context);
        }
        Session session = context.getSession();
        for (ProcessInstance pi : children) {
            if (pi.getId() == rootProcessInstance.getId()) continue;
            ProcessVariableQueryImpl query = new ProcessVariableQueryImpl(context.getCommandService());
            query.processInstanceId(pi.getId());
            List variables = (List)query.list();
            this.saveHistoryProcessInstanceVariables(pi, context, variables);
            session.delete((Object)pi);
            this.deleteProcessInstanceJobs(context, pi, false);
        }
        ProcessVariableQueryImpl query = new ProcessVariableQueryImpl(context.getCommandService());
        query.rootprocessInstanceId(rootProcessInstance.getRootId());
        List variables = (List)query.list();
        this.saveHistoryProcessInstanceVariables(rootProcessInstance, context, variables);
        if (rootProcessInstance.getParentId() > 0L) {
            this.executeParentProcessInstance(context, rootProcessInstance);
        } else {
            context.getExpressionContext().removeContext(rootProcessInstance);
        }
        rootProcessInstance.setState(ProcessInstanceState.End);
        session.delete((Object)rootProcessInstance);
        context.getCommandService().executeCommand(new SaveHistoryProcessInstanceCommand(rootProcessInstance));
        this.deleteProcessInstanceJobs(context, rootProcessInstance, true);
    }

    private void deleteProcessInstanceJobs(Context context, ProcessInstance processInstance, boolean isRoot) {
        Session session = context.getSession();
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        String hql = "from " + Task.class.getName() + " where ";
        hql = isRoot ? hql + "rootProcessInstanceId=:rootProcessInstanceId" : hql + "processInstanceId=:processInstanceId";
        Query query = session.createQuery(hql);
        if (isRoot) {
            query.setLong("rootProcessInstanceId", processInstance.getRootId());
        } else {
            query.setLong("processInstanceId", processInstance.getId());
        }
        List tasks = query.list();
        for (Task t : tasks) {
            if (t.getType().equals((Object)TaskType.Participative)) {
                hql = "delete " + TaskParticipator.class.getName() + " where taskId=:taskId";
                session.createQuery(hql).setLong("taskId", t.getId()).executeUpdate();
            }
            schedulerService.removeReminderJob(t);
            session.delete((Object)t);
        }
    }

    private void executeParentProcessInstance(Context context, ProcessInstance rootProcessInstance) {
        ProcessInstance parentProcessInstance;
        ProcessService processService = context.getProcessService();
        ProcessDefinition parentProcess = processService.getProcessById((parentProcessInstance = processService.getProcessInstanceById(rootProcessInstance.getParentId())).getProcessId());
        Node node = parentProcess.getNode(parentProcessInstance.getCurrentNode());
        if (node instanceof SubprocessNode) {
            SubprocessNode subprocessNode = (SubprocessNode)node;
            HashMap<String, Object> vars = null;
            List<SubprocessVariable> outVariables = subprocessNode.getOutVariables();
            if (outVariables != null && outVariables.size() > 0) {
                vars = new HashMap<String, Object>();
                for (SubprocessVariable var : outVariables) {
                    String key = var.getInParameterKey();
                    Object obj = context.getExpressionContext().eval(rootProcessInstance, "${" + key + "}");
                    if (obj == null) {
                        obj = processService.getProcessVariable(key, rootProcessInstance);
                    }
                    if (obj == null) {
                        throw new IllegalArgumentException("Variable " + key + " value is not found in process instance " + rootProcessInstance.getId());
                    }
                    vars.put(var.getOutParameterKey(), obj);
                }
            }
            if (vars != null) {
                context.getCommandService().executeCommand(new SaveProcessInstanceVariablesCommand(parentProcessInstance, vars));
                context.getExpressionContext().addContextVariables(parentProcessInstance, vars);
            }
        }
        context.getExpressionContext().removeContext(rootProcessInstance);
        String leaveFlowName = node.leave(context, parentProcessInstance, null);
        node.completeActivityHistory(context, parentProcessInstance, leaveFlowName);
    }

    private void saveHistoryProcessInstanceVariables(ProcessInstance rootProcessInstance, Context context, List<Variable> variables) {
        Session session = context.getSession();
        for (Variable var : variables) {
            HistoryBlob hisBlob;
            long blobId;
            HistoryVariable hisVar = new HistoryVariable();
            hisVar.setId(var.getId());
            hisVar.setKey(var.getKey());
            hisVar.setHistoryProcessInstanceId(rootProcessInstance.getHistoryProcessInstanceId());
            if (var instanceof BlobVariable) {
                BlobVariable blobVar = (BlobVariable)var;
                blobId = blobVar.getBlobId();
                hisVar.setStringValue(String.valueOf(blobId));
                hisBlob = new HistoryBlob(blobVar.getValue());
                hisBlob.setId(blobId);
                session.save((Object)hisBlob);
                session.delete((Object)blobVar.getBlob());
            } else if (var instanceof TextVariable) {
                TextVariable textVar = (TextVariable)var;
                blobId = textVar.getBlobId();
                hisVar.setStringValue(String.valueOf(blobId));
                hisBlob = new HistoryBlob(textVar.getValue());
                hisBlob.setId(blobId);
                session.save((Object)hisBlob);
                session.delete((Object)textVar.getBlob());
            } else if (var instanceof DateVariable) {
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
                hisVar.setStringValue(sd.format((Date)var.getValue()));
            } else {
                String stringValue;
                String string = stringValue = var.getValue() == null ? null : var.getValue().toString();
                if (stringValue != null && stringValue.length() > 250) {
                    stringValue = stringValue.substring(0, 250);
                }
                hisVar.setStringValue(stringValue);
            }
            hisVar.setType(var.getType());
            session.save((Object)hisVar);
            session.delete((Object)var);
        }
    }

    @Override
    public NodeType getType() {
        if (this.terminate) {
            return NodeType.TerminalEnd;
        }
        return NodeType.End;
    }

    public boolean isTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean terminate) {
        this.terminate = terminate;
    }
}

