/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.node;

import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.handler.DecisionHandler;
import com.bstek.uflo.process.node.DecisionType;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.NodeType;
import org.apache.commons.lang.StringUtils;

public class DecisionNode
extends Node {
    private static final long serialVersionUID = -6950253419921784972L;
    private String expression;
    private String handlerBean;
    private DecisionType decisionType;

    @Override
    public boolean enter(Context context, ProcessInstance processInstance) {
        return true;
    }

    @Override
    public String leave(Context context, ProcessInstance processInstance, String flowName) {
        if (this.decisionType.equals((Object)DecisionType.Handler)) {
            DecisionHandler handler = (DecisionHandler)context.getApplicationContext().getBean(this.handlerBean);
            flowName = handler.handle(context, processInstance);
        } else {
            Object obj = context.getExpressionContext().eval(processInstance, this.expression);
            if (obj instanceof String) {
                flowName = (String)obj;
            } else {
                throw new IllegalArgumentException("Expression [" + this.expression + "] value type is not a String.");
            }
        }
        if (StringUtils.isEmpty((String)flowName)) {
            throw new IllegalArgumentException("DecisionNode must be specify handlerBean or expression at least one");
        }
        SequenceFlowImpl flow = this.getFlow(flowName);
        if (flow == null) {
            throw new IllegalArgumentException("Sequence flow [" + flowName + "] is not exist!");
        }
        flow.execute(context, processInstance);
        return flow.getName();
    }

    @Override
    public void cancel(Context context, ProcessInstance processInstance) {
    }

    @Override
    public NodeType getType() {
        return NodeType.Decision;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getHandlerBean() {
        return this.handlerBean;
    }

    public void setHandlerBean(String handlerBean) {
        this.handlerBean = handlerBean;
    }

    public DecisionType getDecisionType() {
        return this.decisionType;
    }

    public void setDecisionType(DecisionType decisionType) {
        this.decisionType = decisionType;
    }
}

