/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.process.flow;

import com.bstek.uflo.diagram.SequenceFlowDiagram;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.flow.ConditionType;
import com.bstek.uflo.process.flow.SequenceFlow;
import com.bstek.uflo.process.handler.ConditionHandler;
import com.bstek.uflo.process.node.JoinNode;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.service.ProcessService;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class SequenceFlowImpl
implements SequenceFlow,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String toNode;
    private ConditionType conditionType;
    private String expression;
    private String handlerBean;
    private long processId;
    private String g;
    @JsonIgnore
    private SequenceFlowDiagram diagram;

    public void execute(Context context, ProcessInstance processInstance) {
        Node target;
        ProcessService processService = context.getProcessService();
        ProcessDefinition process = processService.getProcessById(processInstance.getProcessId());
        String sourceNodeName = processInstance.getCurrentNode();
        if (StringUtils.isNotEmpty((String)sourceNodeName)) {
            Node source = process.getNode(processInstance.getCurrentNode());
            source.doLeaveEventHandler(context, processInstance);
            source.completeActivityHistory(context, processInstance, this.getName());
        }
        if (!((target = process.getNode(this.toNode)) instanceof JoinNode)) {
            processInstance.setCurrentNode(target.getName());
            target.createActivityHistory(context, processInstance);
            target.doEnterEventHandler(context, processInstance);
        }
        boolean doLeave = target.enter(context, processInstance);
        if (target instanceof TaskNode || target instanceof StartNode) {
            processInstance.setCurrentTask(target.getName());
        }
        if (doLeave) {
            target.leave(context, processInstance, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canExecute(Context context, ProcessInstance processInstance) {
        boolean result = true;
        if (this.conditionType == null) {
            return result;
        }
        if (this.conditionType.equals((Object)ConditionType.Expression) && StringUtils.isNotEmpty((String)this.expression)) {
            Object obj = context.getExpressionContext().eval(processInstance, this.expression);
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Boolean)) throw new IllegalArgumentException("Expression [" + this.expression + "] value type is not a Boolean.");
            return (Boolean)obj;
        }
        if (!this.conditionType.equals((Object)ConditionType.Handler)) return result;
        if (!StringUtils.isNotEmpty((String)this.handlerBean)) return result;
        ConditionHandler handler = (ConditionHandler)context.getApplicationContext().getBean(this.handlerBean);
        return handler.handle(context, processInstance, this);
    }

    @Override
    public String getToNode() {
        return this.toNode;
    }

    public void setToNode(String toNode) {
        this.toNode = toNode;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Override
    public String getHandlerBean() {
        return this.handlerBean;
    }

    public void setHandlerBean(String handlerBean) {
        this.handlerBean = handlerBean;
    }

    @Override
    public ConditionType getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionType conditionType) {
        this.conditionType = conditionType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }

    public SequenceFlowDiagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(SequenceFlowDiagram diagram) {
        this.diagram = diagram;
    }

    public String getG() {
        return this.g;
    }

    public void setG(String g) {
        this.g = g;
    }
}

