/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.model.variable;

import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.Blob;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.model.variable.VariableType;
import com.bstek.uflo.utils.IDGenerator;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.hibernate.Session;
import org.springframework.util.SerializationUtils;

@Entity
@DiscriminatorValue(value="Text")
public class TextVariable
extends Variable {
    @Column(name="BLOB_ID_")
    private long blobId;
    @Transient
    private String text;
    @Transient
    private Blob blob;

    public TextVariable() {
    }

    public TextVariable(String value, Context context) {
        Blob lob = new Blob(value);
        long id = IDGenerator.getInstance().nextId();
        lob.setId(id);
        this.setBlobId(id);
        Session session = context.getSession();
        session.save((Object)lob);
    }

    public void initValue(Context context) {
        Session session = context.getSession();
        this.blob = (Blob)session.get(Blob.class, (Serializable)Long.valueOf(this.blobId));
        this.text = (String)SerializationUtils.deserialize((byte[])this.blob.getBlobValue());
    }

    public Blob getBlob() {
        return this.blob;
    }

    @Override
    public String getValue() {
        return this.text;
    }

    @Override
    public VariableType getType() {
        return VariableType.Text;
    }

    public long getBlobId() {
        return this.blobId;
    }

    public void setBlobId(long blobId) {
        this.blobId = blobId;
    }
}

