/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.model;

import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryBlob;
import com.bstek.uflo.model.variable.VariableType;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.Session;
import org.springframework.util.SerializationUtils;

@Entity
@Table(name="UFLO_HIS_VARIABLE")
public class HistoryVariable {
    @Id
    @Column(name="ID_")
    private long id;
    @Enumerated(value=EnumType.STRING)
    @Column(name="TYPE_", length=15)
    private VariableType type;
    @Column(name="HIS_PROCESS_INSTANCE_ID_")
    private long historyProcessInstanceId;
    @Column(name="KEY_", length=60)
    private String key;
    @Column(name="VALUE_")
    private String stringValue;
    @Transient
    private Object variableObject;

    public Object getVariableObject() {
        return this.variableObject;
    }

    public void init(Context context) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
        Session session = context.getSession();
        if (this.type.equals((Object)VariableType.Blob) || this.type.equals((Object)VariableType.Text)) {
            HistoryBlob blob = (HistoryBlob)session.get(HistoryBlob.class, (Serializable)Long.valueOf(this.stringValue));
            this.variableObject = SerializationUtils.deserialize((byte[])blob.getBlobValue());
        } else if (this.type.equals((Object)VariableType.String)) {
            this.variableObject = this.stringValue;
        } else if (this.type.equals((Object)VariableType.Date)) {
            try {
                this.variableObject = sd.parse(this.stringValue);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else if (this.type.equals((Object)VariableType.Integer)) {
            this.variableObject = Integer.valueOf(this.stringValue);
        } else if (this.type.equals((Object)VariableType.Character)) {
            this.variableObject = Character.valueOf((char)this.stringValue.getBytes()[0]);
        } else if (this.type.equals((Object)VariableType.Double)) {
            this.variableObject = Double.valueOf(this.stringValue);
        } else if (this.type.equals((Object)VariableType.Float)) {
            this.variableObject = Float.valueOf(this.stringValue);
        } else if (this.type.equals((Object)VariableType.Long)) {
            this.variableObject = Long.valueOf(this.stringValue);
        } else if (this.type.equals((Object)VariableType.Byte)) {
            this.variableObject = Byte.valueOf(this.stringValue);
        } else if (this.type.equals((Object)VariableType.Short)) {
            this.variableObject = Short.valueOf(this.stringValue);
        } else if (this.type.equals((Object)VariableType.Boolean)) {
            this.variableObject = Boolean.valueOf(this.stringValue);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getHistoryProcessInstanceId() {
        return this.historyProcessInstanceId;
    }

    public void setHistoryProcessInstanceId(long historyProcessInstanceId) {
        this.historyProcessInstanceId = historyProcessInstanceId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
    }

    public VariableType getType() {
        return this.type;
    }

    public void setType(VariableType type) {
        this.type = type;
    }
}

