/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.heartbeat;

import com.bstek.uflo.heartbeat.DetectionJobDetail;
import com.bstek.uflo.heartbeat.HeartbeatDetectionJob;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.text.ParseException;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SessionFactory;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.simpl.SimpleThreadPool;
import org.springframework.beans.factory.InitializingBean;

public class InstanceDetection
implements InitializingBean {
    public static final String BEAN_ID = "uflo.instanceDetection";
    private String instanceNames;
    private Scheduler scheduler;
    private boolean disableScheduler;
    private SchedulerService schedulerService;
    private String detectionCron = "0/30 * * * * ?";
    private Logger log = Logger.getGlobal();

    private void startDaemonJob() throws Exception {
        if (this.disableScheduler) {
            this.log.info("Current uflo application is disabled scheduler...");
            return;
        }
        String currentInstanceName = System.getProperty("uflo.instanceName");
        if (StringUtils.isBlank((String)this.instanceNames)) {
            if (StringUtils.isNotBlank((String)currentInstanceName)) {
                this.log.info("Uflo job cluster names is empty,but system property \"uflo.instanceName\" value is \"" + currentInstanceName + "\",so Uflo job run mode is single still...");
            } else {
                this.log.info("Uflo job run mode is single...");
            }
            this.schedulerService.resetScheduer();
            return;
        }
        if (StringUtils.isBlank((String)currentInstanceName)) {
            String msg = "Current uflo application configured cluster names \"" + this.instanceNames + "\",but not configure system property \"uflo.instanceName\".";
            this.log.info(msg);
            throw new RuntimeException(msg);
        }
        this.log.info("Uflo job run mode is cluster...");
        this.initDetectionScheduler();
        JobDetailImpl jobDetail = this.initJobDetail(currentInstanceName);
        Trigger trigger = this.initTrigger();
        HeartbeatDetectionJob detectionJob = new HeartbeatDetectionJob();
        jobDetail.setJobClass(detectionJob.getClass());
        this.scheduler.scheduleJob((JobDetail)jobDetail, trigger);
        this.scheduler.start();
        this.log.info("Uflo cluster daemon scheduler is started...");
    }

    private void initDetectionScheduler() throws Exception {
        StdSchedulerFactory factory = new StdSchedulerFactory();
        Properties mergedProps = new Properties();
        mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        mergedProps.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
        mergedProps.setProperty("org.quartz.scheduler.instanceName", "UfloClusterHeartbeatScheduler");
        mergedProps.setProperty("org.quartz.scheduler.instanceId", "UfloHeartbeatDetectionScheduler");
        mergedProps.setProperty("org.quartz.threadPool.threadCount", "2");
        factory.initialize(mergedProps);
        this.scheduler = factory.getScheduler();
    }

    private JobDetailImpl initJobDetail(String currentInstanceName) {
        String[] clusterJobInstanceNames = this.instanceNames.split(",");
        SessionFactory sessionFactory = EnvironmentUtils.getEnvironment().getSessionFactory();
        DetectionJobDetail jobDetail = new DetectionJobDetail(sessionFactory, currentInstanceName, clusterJobInstanceNames, this.schedulerService);
        jobDetail.setKey(new JobKey("UfloDaemonJobDetail"));
        jobDetail.setName("UfloDaemonDetectionJobDetail");
        return jobDetail;
    }

    private Trigger initTrigger() {
        CronTriggerImpl trigger = new CronTriggerImpl();
        trigger.setName("UfloHeartbeatTrigger");
        trigger.setKey(new TriggerKey("UfloHeartbeatTrigger"));
        try {
            trigger.setCronExpression(this.detectionCron);
            return trigger;
        }
        catch (ParseException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.startDaemonJob();
    }

    public void setDisableScheduler(boolean disableScheduler) {
        this.disableScheduler = disableScheduler;
    }

    public void setInstanceNames(String instanceNames) {
        this.instanceNames = instanceNames;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setDetectionCron(String detectionCron) {
        this.detectionCron = detectionCron;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

