/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.heartbeat;

import com.bstek.uflo.heartbeat.DetectionJobDetail;
import com.bstek.uflo.heartbeat.HeartJob;
import com.bstek.uflo.heartbeat.HeartJobDetail;
import com.bstek.uflo.model.Heartbeat;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.triggers.CronTriggerImpl;

public class HeartbeatDetectionJob
implements Job {
    private String heartJobCronExpression = "0/30 * * * * ?";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        DetectionJobDetail jobDetail = (DetectionJobDetail)context.getJobDetail();
        Session session = jobDetail.getSessionFactory().openSession();
        try {
            String currentInstanceName = jobDetail.getCurrentInstanceName();
            Operation operation = this.detection(session, jobDetail.getJobInstanceNames(), currentInstanceName);
            if (operation.equals((Object)Operation.reset)) {
                SchedulerService service = jobDetail.getSchedulerService();
                service.resetScheduer();
                Heartbeat beat = new Heartbeat();
                Calendar c = Calendar.getInstance();
                c.setTime(new Date());
                c.add(13, 1);
                beat.setDate(c.getTime());
                beat.setId(UUID.randomUUID().toString());
                beat.setInstanceName(currentInstanceName);
                session.save((Object)beat);
                this.initHeartJob(currentInstanceName, service.getScheduler());
            }
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            session.flush();
            session.close();
        }
    }

    private void initHeartJob(String currentInstanceName, Scheduler scheduler) throws Exception {
        HeartJobDetail heartJobDetail = this.buildHeartJobDetail(currentInstanceName);
        Trigger heartJobTrigger = this.buildHeartJobTrigger();
        scheduler.scheduleJob((JobDetail)heartJobDetail, heartJobTrigger);
    }

    private HeartJobDetail buildHeartJobDetail(String currentInstanceName) {
        SessionFactory sessionFactory = EnvironmentUtils.getEnvironment().getSessionFactory();
        HeartJobDetail jobDetail = new HeartJobDetail(sessionFactory, currentInstanceName);
        jobDetail.setKey(new JobKey("UfloHeartJob", "uflo_background_system_job"));
        jobDetail.setJobClass(HeartJob.class);
        return jobDetail;
    }

    private Trigger buildHeartJobTrigger() {
        CronTriggerImpl trigger = new CronTriggerImpl();
        trigger.setName("UfloHeartJobTrigger");
        try {
            trigger.setCronExpression(this.heartJobCronExpression);
            return trigger;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private Operation detection(Session session, String[] clusterJobInstanceNames, String currentInstanceName) {
        Query query = session.createQuery("from " + Heartbeat.class.getName() + " b order by b.date desc");
        List heartbeats = query.setMaxResults(1).list();
        int currentPos = this.getPosition(clusterJobInstanceNames, currentInstanceName) + 1;
        if (heartbeats.size() > 0) {
            Date now = new Date();
            Heartbeat heartbeat = (Heartbeat)heartbeats.get(0);
            Date beatDate = heartbeat.getDate();
            Calendar beatCalendar = Calendar.getInstance();
            beatCalendar.setTime(beatDate);
            String beatInstanceName = heartbeat.getInstanceName();
            int secondUnit = 40;
            int beatPos = this.getPosition(clusterJobInstanceNames, beatInstanceName) + 1;
            if (!currentInstanceName.equals(beatInstanceName)) {
                int currentSecond = currentPos * secondUnit;
                if (currentPos > beatPos) {
                    beatCalendar.add(13, currentSecond);
                } else if (currentPos < beatPos) {
                    currentSecond = (currentPos + (clusterJobInstanceNames.length - beatPos)) * secondUnit;
                    beatCalendar.add(13, currentSecond);
                }
            } else {
                beatCalendar.add(13, secondUnit * clusterJobInstanceNames.length);
            }
            if (now.compareTo(beatCalendar.getTime()) > 0) {
                return Operation.reset;
            }
        } else if (currentPos == 1) {
            return Operation.reset;
        }
        return Operation.donothing;
    }

    private int getPosition(String[] instanceNames, String instanceName) {
        int pos = 0;
        for (int i = 0; i < instanceNames.length; ++i) {
            String name = instanceNames[i];
            if (!name.equals(instanceName)) continue;
            pos = i;
        }
        return pos;
    }

    static enum Operation {
        reset,
        donothing;

    }
}

