/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.heartbeat;

import com.bstek.uflo.heartbeat.HeartJobDetail;
import com.bstek.uflo.model.Heartbeat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.hibernate.Query;
import org.hibernate.Session;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class HeartJob
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        HeartJobDetail detail = (HeartJobDetail)context.getJobDetail();
        String instanceName = detail.getCurrentInstanceName();
        Session session = detail.getSessionFactory().openSession();
        try {
            String hql = "from " + Heartbeat.class.getName() + " b where b.instanceName=:instanceName order by b.date desc";
            Query query = session.createQuery(hql).setString("instanceName", instanceName);
            List beats = query.list();
            Date now = new Date();
            Heartbeat beat = null;
            if (beats.size() > 0) {
                beat = (Heartbeat)beats.get(0);
            } else {
                beat = new Heartbeat();
                beat.setId(UUID.randomUUID().toString());
                beat.setInstanceName(instanceName);
            }
            beat.setDate(now);
            session.saveOrUpdate((Object)beat);
        }
        catch (Exception ex) {
            throw new JobExecutionException((Throwable)ex);
        }
        finally {
            session.flush();
            session.close();
        }
    }
}

