/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.expr.impl;

import com.bstek.uflo.expr.ExpressionContext;
import com.bstek.uflo.expr.ExpressionProvider;
import com.bstek.uflo.expr.impl.ProcessMapContext;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.query.ProcessInstanceQuery;
import com.bstek.uflo.service.CacheService;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ExpressionContextImpl
implements ExpressionContext,
ApplicationContextAware,
InitializingBean {
    private Log log = LogFactory.getLog(this.getClass());
    private Collection<ExpressionProvider> providers;
    private static final JexlEngine jexl = new JexlEngine();
    private ProcessService processService;

    @Override
    public MapContext createContext(ProcessInstance processInstance, Map<String, Object> variables) {
        ProcessMapContext context = new ProcessMapContext();
        if (variables != null && variables.size() > 0) {
            for (String key : variables.keySet()) {
                context.set(key, variables.get(key));
            }
        }
        for (ExpressionProvider provider : this.providers) {
            Map<String, Object> data;
            if (!provider.support(processInstance) || (data = provider.getData(processInstance)) == null || data.size() <= 0) continue;
            for (String key : data.keySet()) {
                context.set(key, data.get(key));
            }
        }
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        cacheService.putContext(processInstance.getId(), context);
        return context;
    }

    @Override
    public boolean removeContext(ProcessInstance processInstance) {
        long id = processInstance.getId();
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        if (cacheService.containsContext(id)) {
            cacheService.removeContext(id);
            return true;
        }
        return false;
    }

    @Override
    public void removeContextVariables(long processInstanceId, String key) {
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        ProcessMapContext context = cacheService.getContext(processInstanceId);
        if (context != null) {
            ProcessMapContext processMap = context;
            processMap.getMap().remove(key);
        }
    }

    @Override
    public synchronized String evalString(ProcessInstance processInstance, String str) {
        return this.parseExpression(str, processInstance);
    }

    @Override
    public synchronized Object eval(long processInstanceId, String expression) {
        if (!(expression = expression.trim()).startsWith("${") || !expression.endsWith("}")) {
            return expression;
        }
        expression = expression.substring(2, expression.length() - 1);
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        ProcessMapContext context = cacheService.getContext(processInstanceId);
        if (context == null) {
            this.buildProcessInstanceContext(this.processService.getProcessInstanceById(processInstanceId));
            context = cacheService.getContext(processInstanceId);
        }
        if (context == null) {
            this.log.warn((Object)("ProcessInstance " + processInstanceId + " variable context is not exist!"));
            return null;
        }
        Object obj = null;
        try {
            obj = jexl.createExpression(expression).evaluate((JexlContext)context);
        }
        catch (JexlException ex) {
            this.log.info((Object)("Named " + expression + " variable was not found in ProcessInstance " + processInstanceId));
        }
        return obj;
    }

    private void buildProcessInstanceContext(ProcessInstance processInstance) {
        List<Variable> variables = this.processService.getProcessVariables(processInstance.getId());
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        for (Variable var : variables) {
            variableMap.put(var.getKey(), var.getValue());
        }
        this.createContext(processInstance, variableMap);
    }

    private String parseExpression(String str, ProcessInstance processInstance) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        Pattern p = Pattern.compile("\\$\\{[^\\}][0-9a-zA-Z]([^\\}]*[0-9a-zA-Z])\\}");
        Matcher m = p.matcher(str);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (m.find()) {
            String expr = m.group();
            Object obj = this.eval(processInstance, expr);
            String evalValue = obj == null ? null : obj.toString();
            sb.append(str.substring(i, m.start()));
            sb.append(evalValue);
            i = m.end();
        }
        if (sb.length() > 0) {
            sb.append(str.substring(i));
            return sb.toString();
        }
        return str;
    }

    @Override
    public synchronized Object eval(ProcessInstance processInstance, String expression) {
        return this.getProcessExpressionValue(processInstance, expression);
    }

    private Object getProcessExpressionValue(ProcessInstance processInstance, String expression) {
        Object obj = this.eval(processInstance.getId(), expression);
        if (obj != null) {
            return obj;
        }
        if (processInstance.getParentId() > 0L) {
            ProcessInstance parentProcessInstance = this.processService.getProcessInstanceById(processInstance.getParentId());
            return this.getProcessExpressionValue(parentProcessInstance, expression);
        }
        ArrayList<ProcessInstance> children = new ArrayList<ProcessInstance>();
        this.retriveAllChildProcessInstance(children, processInstance.getId());
        for (ProcessInstance pi : children) {
            Object result = this.eval(pi.getId(), expression);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void retriveAllChildProcessInstance(List<ProcessInstance> children, long parentId) {
        ProcessInstanceQuery query = this.processService.createProcessInstanceQuery();
        query.parentId(parentId);
        List list = (List)query.list();
        for (ProcessInstance pi : list) {
            this.retriveAllChildProcessInstance(children, pi.getId());
        }
        children.addAll(list);
    }

    @Override
    public void addContextVariables(ProcessInstance processInstance, Map<String, Object> variables) {
        if (variables == null || variables.size() < 1) {
            return;
        }
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        ProcessMapContext context = cacheService.getContext(processInstance.getId());
        if (context == null) {
            this.buildProcessInstanceContext(processInstance);
            context = cacheService.getContext(processInstance.getId());
        }
        if (context == null) {
            throw new IllegalArgumentException("ProcessInstance [" + processInstance.getId() + "] expression context is not exist!");
        }
        for (String key : variables.keySet()) {
            context.set(key, variables.get(key));
        }
    }

    @Override
    public void moveContextToParent(ProcessInstance processInstance) {
        long parentId = processInstance.getParentId();
        if (parentId < 1L) {
            return;
        }
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        ProcessMapContext parentContext = cacheService.getContext(parentId);
        if (parentContext == null) {
            this.buildProcessInstanceContext(this.processService.getProcessInstanceById(parentId));
            parentContext = cacheService.getContext(parentId);
        }
        if (parentContext == null) {
            throw new IllegalArgumentException("ProcessInstance " + parentId + " context is not exist!");
        }
        ProcessMapContext context = cacheService.getContext(processInstance.getId());
        if (context == null) {
            this.buildProcessInstanceContext(processInstance);
            context = cacheService.getContext(processInstance.getId());
        }
        if (context == null) {
            throw new IllegalArgumentException("ProcessInstance " + processInstance.getId() + " context is not exist!");
        }
        Map<String, Object> map = context.getMap();
        for (String key : map.keySet()) {
            parentContext.set(key, map.get(key));
        }
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.providers = applicationContext.getBeansOfType(ExpressionProvider.class).values();
    }

    public void initExpressionContext() {
        CacheService cacheService = EnvironmentUtils.getEnvironment().getCache();
        ProcessInstanceQuery query = this.processService.createProcessInstanceQuery();
        List instances = (List)query.list();
        for (ProcessInstance pi : instances) {
            ProcessMapContext context = new ProcessMapContext();
            for (Variable var : this.processService.getProcessVariables(pi.getId())) {
                context.set(var.getKey(), var.getValue());
            }
            cacheService.putContext(pi.getId(), context);
        }
    }

    public void afterPropertiesSet() throws Exception {
    }

    static {
        jexl.setLenient(false);
        jexl.setSilent(false);
    }
}

