/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.validate.impl;

import com.bstek.uflo.deploy.validate.Validator;
import com.bstek.uflo.deploy.validate.impl.ActionNodeValidator;
import com.bstek.uflo.deploy.validate.impl.DecisionNodeValidator;
import com.bstek.uflo.deploy.validate.impl.EndNodeValidator;
import com.bstek.uflo.deploy.validate.impl.ForeachNodeValidator;
import com.bstek.uflo.deploy.validate.impl.ForkNodeValidator;
import com.bstek.uflo.deploy.validate.impl.StartNodeValidator;
import com.bstek.uflo.deploy.validate.impl.SubprocessNodeValidator;
import com.bstek.uflo.deploy.validate.impl.SwimlaneValidator;
import com.bstek.uflo.deploy.validate.impl.TaskNodeValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProcessValidator
implements Validator {
    private List<Validator> validators = new ArrayList<Validator>();

    public ProcessValidator() {
        this.validators.add(new ActionNodeValidator());
        this.validators.add(new DecisionNodeValidator());
        this.validators.add(new EndNodeValidator());
        this.validators.add(new ForeachNodeValidator());
        this.validators.add(new ForkNodeValidator());
        this.validators.add(new StartNodeValidator());
        this.validators.add(new SubprocessNodeValidator());
        this.validators.add(new SwimlaneValidator());
        this.validators.add(new TaskNodeValidator());
    }

    @Override
    public void validate(Element element, List<String> errors, List<String> nodeNames) {
        boolean hasStart = false;
        boolean hasEnd = false;
        String name = element.getAttribute("name");
        if (StringUtils.isEmpty((String)name)) {
            errors.add("\u6d41\u7a0b\u6a21\u7248\u672a\u5b9a\u4e49\u540d\u79f0");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)node;
            for (Validator validator : this.validators) {
                if (!validator.support(childElement)) continue;
                if (validator instanceof StartNodeValidator) {
                    hasStart = true;
                }
                if (validator instanceof EndNodeValidator) {
                    hasEnd = true;
                }
                validator.validate(childElement, errors, nodeNames);
            }
        }
        if (!hasStart) {
            errors.add("\u6d41\u7a0b\u6a21\u7248\u4e2d\u672a\u5b9a\u4e49\u5f00\u59cb\u8282\u70b9\u3002");
        }
        if (!hasEnd) {
            errors.add("\u6d41\u7a0b\u6a21\u7248\u4e2d\u672a\u5b9a\u4e49\u7ed3\u675f\u8282\u70b9\u3002");
        }
    }

    @Override
    public boolean support(Element element) {
        return element.getNodeName().equals("uflo-process");
    }

    @Override
    public String getNodeName() {
        return "\u6d41\u7a0b\u6a21\u7248";
    }
}

