/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.parse.impl;

import com.bstek.uflo.deploy.parse.AbstractTaskParser;
import com.bstek.uflo.diagram.NodeDiagram;
import com.bstek.uflo.diagram.ShapeType;
import com.bstek.uflo.model.task.DateUnit;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.process.node.AssignmentType;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.process.node.reminder.CalendarInfo;
import com.bstek.uflo.process.node.reminder.DueAction;
import com.bstek.uflo.process.node.reminder.DueDefinition;
import com.bstek.uflo.process.node.reminder.PeriodReminder;
import com.bstek.uflo.process.node.reminder.Reminder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class TaskParser
extends AbstractTaskParser {
    @Override
    public Object parse(Element element, long processId, boolean parseChildren) {
        String taskType;
        String allowSpecifyAssigne;
        String taskListenerBean;
        String countersignHandler;
        String countersignExpression;
        String countersignPercentMultiplicity;
        TaskNode node = new TaskNode();
        node.setProcessId(processId);
        this.parseNodeCommonInfo(element, node);
        node.setSequenceFlows(this.parseFlowElement(element, processId, parseChildren));
        String countersignMultiplicity = element.attributeValue("countersign-multiplicity");
        if (StringUtils.isNotEmpty((String)countersignMultiplicity)) {
            node.setCountersignMultiplicity(Integer.valueOf(countersignMultiplicity));
        }
        if (StringUtils.isNotEmpty((String)(countersignPercentMultiplicity = element.attributeValue("countersign-percent-multiplicity")))) {
            node.setCountersignPercentMultiplicity(Integer.valueOf(countersignPercentMultiplicity));
        }
        if (StringUtils.isNotEmpty((String)(countersignExpression = element.attributeValue("countersign-expression")))) {
            node.setCountersignExpression(countersignExpression);
        }
        if (StringUtils.isNotEmpty((String)(countersignHandler = element.attributeValue("countersign-handler")))) {
            node.setCountersignHandler(countersignHandler);
        }
        if (StringUtils.isNotEmpty((String)(taskListenerBean = element.attributeValue("task-listener-bean")))) {
            node.setTaskListenerBean(taskListenerBean);
        }
        node.setAssignmentType(AssignmentType.valueOf(element.attributeValue("assignment-type")));
        node.setAssignmentHandlerBean(this.unescape(element.attributeValue("assignment-handler-bean")));
        node.setSwimlane(this.unescape(element.attributeValue("swimlane")));
        node.setExpression(this.unescape(element.attributeValue("expression")));
        if (node.getAssignmentType().equals((Object)AssignmentType.Assignee)) {
            node.setAssignees(this.parserAssignees(element));
        }
        if (StringUtils.isNotEmpty((String)(allowSpecifyAssigne = element.attributeValue("allow-specify-assignee")))) {
            node.setAllowSpecifyAssignee(Boolean.valueOf(allowSpecifyAssigne));
        }
        if (StringUtils.isNotEmpty((String)(taskType = element.attributeValue("task-type")))) {
            node.setTaskType(TaskType.valueOf(taskType));
        }
        node.setUrl(this.unescape(element.attributeValue("url")));
        node.setFormTemplate(this.unescape(element.attributeValue("form-template")));
        node.setTaskName(this.unescape(element.attributeValue("task-name")));
        node.setComponentAuthorities(this.parseComponentAuthorities(element));
        node.setDueDefinition(this.parseDueDefinition(element));
        node.setFormElements(this.parseFormElements(element));
        node.setUserData(this.parseUserData(element));
        NodeDiagram diagram = this.parseDiagram(element);
        if (TaskType.Countersign.equals((Object)node.getTaskType())) {
            diagram.setIcon("/icons/task-countersign.svg");
        } else {
            diagram.setIcon("/icons/task.svg");
        }
        diagram.setShapeType(ShapeType.Rectangle);
        diagram.setBorderWidth(1);
        diagram.setBorderColor("3, 104, 154");
        diagram.setBackgroundColor("250, 250, 250");
        node.setDiagram(diagram);
        return node;
    }

    private DueDefinition parseDueDefinition(Element element) {
        DueDefinition reminderDef = null;
        for (Object obj : element.elements()) {
            String minuteStr;
            String dayHour;
            String dayStr;
            Element ele;
            if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("due")) continue;
            if (reminderDef == null) {
                reminderDef = new DueDefinition();
            }
            if (StringUtils.isNotEmpty((String)(dayStr = ele.attributeValue("day")))) {
                reminderDef.setDay(Integer.valueOf(dayStr));
            }
            if (StringUtils.isNotEmpty((String)(dayHour = ele.attributeValue("hour")))) {
                reminderDef.setHour(Integer.valueOf(dayHour));
            }
            if (StringUtils.isNotEmpty((String)(minuteStr = ele.attributeValue("minute")))) {
                reminderDef.setMinute(Integer.valueOf(minuteStr));
            }
            reminderDef.setCalendarInfos(this.parseCalendarProviders(ele));
            for (Object child : ele.elements()) {
                String minute;
                String hour;
                Reminder reminder;
                if (!(child instanceof Element)) continue;
                Element childEle = (Element)child;
                String name = childEle.getName();
                if (name.equals("once-reminder")) {
                    reminder = new Reminder();
                    reminder.setHandlerBean(this.unescape(childEle.attributeValue("handler-bean")));
                    reminderDef.setReminder(reminder);
                    continue;
                }
                if (name.equals("period-reminder")) {
                    reminder = new PeriodReminder();
                    reminder.setHandlerBean(this.unescape(childEle.attributeValue("handler-bean")));
                    ((PeriodReminder)reminder).setRepeat(Integer.valueOf(childEle.attributeValue("repeat")));
                    ((PeriodReminder)reminder).setUnit(DateUnit.valueOf(childEle.attributeValue("unit")));
                    ((PeriodReminder)reminder).setCalendarInfos(this.parseCalendarProviders(childEle));
                    reminderDef.setReminder(reminder);
                    continue;
                }
                if (!name.equals("due-action")) continue;
                DueAction action = new DueAction();
                String day = childEle.attributeValue("day");
                if (StringUtils.isNotEmpty((String)day)) {
                    action.setDay(Integer.valueOf(day));
                }
                if (StringUtils.isNotEmpty((String)(hour = childEle.attributeValue("hour")))) {
                    action.setHour(Integer.valueOf(hour));
                }
                if (StringUtils.isNotEmpty((String)(minute = childEle.attributeValue("minute")))) {
                    action.setMinute(Integer.valueOf(minute));
                }
                action.setCalendarInfos(this.parseCalendarProviders(childEle));
                action.setHandlerBean(this.unescape(childEle.attributeValue("handler-bean")));
                reminderDef.setDueAction(action);
            }
        }
        return reminderDef;
    }

    private List<CalendarInfo> parseCalendarProviders(Element element) {
        ArrayList<CalendarInfo> list = new ArrayList<CalendarInfo>();
        for (Object obj : element.elements()) {
            Element ele;
            if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("calendar-provider")) continue;
            CalendarInfo info = new CalendarInfo();
            info.setId(this.unescape(ele.attributeValue("id")));
            info.setName(this.unescape(ele.attributeValue("name")));
            list.add(info);
        }
        return list;
    }

    @Override
    public boolean support(Element element) {
        return element.getName().equals("task");
    }
}

