/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.parse.impl;

import com.bstek.uflo.deploy.parse.AbstractParser;
import com.bstek.uflo.diagram.NodeDiagram;
import com.bstek.uflo.diagram.ShapeType;
import com.bstek.uflo.process.node.SubprocessNode;
import com.bstek.uflo.process.node.SubprocessType;
import com.bstek.uflo.process.node.SubprocessVariable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class SubprocessParser
extends AbstractParser {
    @Override
    public Object parse(Element element, long processId, boolean parseChildren) {
        String completeStartTask;
        SubprocessNode node = new SubprocessNode();
        node.setProcessId(processId);
        this.parseNodeCommonInfo(element, node);
        node.setSequenceFlows(this.parseFlowElement(element, processId, parseChildren));
        String type = element.attributeValue("subprocess-type");
        if (StringUtils.isNotEmpty((String)type)) {
            node.setSubprocessType(SubprocessType.valueOf(type));
        }
        if (StringUtils.isNotBlank((String)(completeStartTask = element.attributeValue("complete-start-task")))) {
            node.setCompleteStartTask(Boolean.valueOf(completeStartTask));
        }
        node.setSubprocessId(this.unescape(element.attributeValue("subprocess-id")));
        node.setSubprocessKey(this.unescape(element.attributeValue("subprocess-key")));
        node.setSubprocessName(this.unescape(element.attributeValue("subprocess-name")));
        ArrayList<SubprocessVariable> inVars = new ArrayList<SubprocessVariable>();
        ArrayList<SubprocessVariable> outVars = new ArrayList<SubprocessVariable>();
        for (Object obj : element.elements()) {
            SubprocessVariable var;
            if (!(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            if (ele.getName().equals("in-subprocess-variable")) {
                var = new SubprocessVariable(this.unescape(ele.attributeValue("in-parameter-key")), this.unescape(ele.attributeValue("out-parameter-key")));
                inVars.add(var);
            }
            if (!ele.getName().equals("out-subprocess-variable")) continue;
            var = new SubprocessVariable(this.unescape(ele.attributeValue("in-parameter-key")), this.unescape(ele.attributeValue("out-parameter-key")));
            outVars.add(var);
        }
        node.setInVariables(inVars);
        node.setOutVariables(outVars);
        NodeDiagram diagram = this.parseDiagram(element);
        diagram.setIcon("/icons/subprocess.svg");
        diagram.setShapeType(ShapeType.Rectangle);
        diagram.setBorderWidth(1);
        diagram.setBorderColor("3, 104, 154");
        diagram.setBackgroundColor("250, 250, 250");
        node.setDiagram(diagram);
        return node;
    }

    @Override
    public boolean support(Element element) {
        return element.getName().equals("subprocess");
    }
}

