/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.parse.impl;

import com.bstek.uflo.deploy.parse.Parser;
import com.bstek.uflo.diagram.Point;
import com.bstek.uflo.diagram.SequenceFlowDiagram;
import com.bstek.uflo.process.flow.ConditionType;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class SequenceFlowParser
implements Parser {
    @Override
    public Object parse(Element element, long processId, boolean parseChildren) {
        SequenceFlowImpl flow = new SequenceFlowImpl();
        flow.setProcessId(processId);
        flow.setName(this.unescape(element.attributeValue("name")));
        flow.setToNode(this.unescape(element.attributeValue("to")));
        String conditionType = element.attributeValue("condition-type");
        if (StringUtils.isNotEmpty((String)conditionType)) {
            flow.setConditionType(ConditionType.valueOf(conditionType));
            flow.setExpression(element.attributeValue("expression"));
            flow.setHandlerBean(element.attributeValue("handler-bean"));
        }
        flow.setDiagram(this.parseDiagram(element));
        String g = element.attributeValue("g");
        if (StringUtils.isNotBlank((String)g)) {
            int pos = g.indexOf(":");
            if (pos > -1) {
                g = g.substring(0, pos);
                g = g.replaceAll(";", ",");
            } else {
                g = null;
            }
        }
        flow.setG(g);
        return flow;
    }

    private SequenceFlowDiagram parseDiagram(Element element) {
        SequenceFlowDiagram diagram = new SequenceFlowDiagram();
        diagram.setBorderColor("0,69,123");
        diagram.setFontColor("0,69,123");
        diagram.setBorderWidth(2);
        String name = element.attributeValue("name");
        diagram.setTo(element.attributeValue("to"));
        diagram.setName(name);
        String g = element.attributeValue("g");
        if (StringUtils.isEmpty((String)g)) {
            return diagram;
        }
        String[] pointInfos = null;
        if (StringUtils.isNotEmpty((String)name)) {
            String[] info = g.split(":");
            if (info.length == 1) {
                diagram.setLabelPosition(info[0]);
                return diagram;
            }
            pointInfos = info[0].split(";");
            diagram.setLabelPosition(info[1]);
        } else {
            String[] info = g.split(":");
            pointInfos = info.length == 0 ? g.split(";") : info[0].split(";");
            if (pointInfos.length == 0) {
                return diagram;
            }
        }
        diagram.setPoints(this.buildPoint(pointInfos));
        return diagram;
    }

    private List<Point> buildPoint(String[] info) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (String diagram : info) {
            String[] d = diagram.split(",");
            if (StringUtils.isEmpty((String)d[0]) || d.length <= 1) continue;
            for (int i = 0; i < d.length; i += 2) {
                Point point = new Point();
                point.setX(Integer.valueOf(d[i]));
                point.setY(Integer.valueOf(d[i + 1]));
                points.add(point);
            }
        }
        return points;
    }

    @Override
    public boolean support(Element element) {
        return element.getName().equals("sequence-flow");
    }

    protected String unescape(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        str = StringEscapeUtils.escapeXml((String)str);
        return StringEscapeUtils.unescapeXml((String)str);
    }
}

