/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.parse.impl;

import com.bstek.uflo.deploy.parse.AbstractParser;
import com.bstek.uflo.deploy.parse.Parser;
import com.bstek.uflo.deploy.parse.impl.ProcessDiagramBudiler;
import com.bstek.uflo.diagram.ProcessDiagram;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.process.swimlane.Swimlane;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class ProcessParser
extends AbstractParser {
    private static ProcessParser processParser;
    private static final Log log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinition parseProcess(byte[] bytes, long processId, boolean parseChildren) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)bin);
            Element root = document.getRootElement();
            if (processParser.support(root)) {
                ProcessDefinition pd;
                ProcessDefinition processDefinition = pd = (ProcessDefinition)processParser.parse(root, processId, parseChildren);
                return processDefinition;
            }
            ProcessDefinition processDefinition = null;
            return processDefinition;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bin);
        }
    }

    @Override
    public Object parse(Element element, long processId, boolean parseChildren) {
        Element descElement;
        ProcessDefinition process = new ProcessDefinition();
        process.setId(processId);
        process.setEventHandlerBean(this.unescape(element.attributeValue("event-handler-bean")));
        process.setName(this.unescape(element.attributeValue("name")));
        process.setStartProcessUrl(this.unescape(element.attributeValue("start-process-url")));
        process.setKey(this.unescape(element.attributeValue("key")));
        process.setCategoryId(this.unescape(element.attributeValue("category-id")));
        process.setCategory(this.unescape(element.attributeValue("category")));
        String effectDateStr = this.unescape(element.attributeValue("effect-date"));
        if (StringUtils.isNotEmpty((String)effectDateStr)) {
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                process.setEffectDate(sd.parse(effectDateStr));
            }
            catch (ParseException e) {
                log.error((Object)("Process definition " + process.getName() + " effect date is invalid:" + effectDateStr));
            }
        }
        if (StringUtils.isEmpty((String)process.getCategoryId())) {
            process.setCategoryId(EnvironmentUtils.getEnvironment().getCategoryId());
        }
        if ((descElement = element.element("description")) != null) {
            String desc = descElement.getTextTrim();
            desc = desc.length() > 120 ? desc.substring(0, 120) : desc;
            process.setDescription(this.unescape(desc));
        }
        if (parseChildren) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Swimlane> swimlanes = new ArrayList<Swimlane>();
            block2: for (Object obj : element.elements()) {
                if (!(obj instanceof Element)) continue;
                Element childElement = (Element)obj;
                for (Parser parser : this.parsers) {
                    if (!parser.support(childElement)) continue;
                    Object processElement = parser.parse(childElement, processId, parseChildren);
                    if (processElement instanceof Node) {
                        Node node = (Node)processElement;
                        node.setProcessId(processId);
                        nodes.add(node);
                    }
                    if (processElement instanceof StartNode) {
                        process.setStartNode((StartNode)processElement);
                    }
                    if (!(processElement instanceof Swimlane)) continue block2;
                    swimlanes.add((Swimlane)processElement);
                    continue block2;
                }
            }
            process.setSwimlanes(swimlanes);
            process.setNodes(nodes);
        }
        if (parseChildren) {
            process.setDiagram(this.buildProcessDiagram(process));
        }
        return process;
    }

    private ProcessDiagram buildProcessDiagram(ProcessDefinition process) {
        ProcessDiagramBudiler processDiagramBuilder = new ProcessDiagramBudiler(process);
        return processDiagramBuilder.getDiagram();
    }

    @Override
    public boolean support(Element element) {
        return element.getName().equals("uflo-process");
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        processParser = this;
    }

    static {
        log = LogFactory.getLog(ProcessParser.class);
    }
}

