/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.parse.impl;

import com.bstek.uflo.diagram.NodeDiagram;
import com.bstek.uflo.diagram.Point;
import com.bstek.uflo.diagram.ProcessDiagram;
import com.bstek.uflo.diagram.SequenceFlowDiagram;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.Node;
import java.util.ArrayList;
import java.util.List;

public class ProcessDiagramBudiler {
    private int width = 0;
    private int height = 0;
    private int nodeWidth = 0;
    private int nodeHeight = 0;
    private ProcessDefinition process;
    private ProcessDiagram diagram;
    private List<SequenceFlowImpl> processedSequenceFLows = new ArrayList<SequenceFlowImpl>();

    public ProcessDiagramBudiler(ProcessDefinition process) {
        this.process = process;
        this.createDiagram();
    }

    private void createDiagram() {
        this.buildSize(this.process.getStartNode());
        this.diagram = new ProcessDiagram();
        this.diagram.setName(this.process.getName());
        this.diagram.setWidth(this.width + this.nodeWidth + 30);
        this.diagram.setHeight(this.height + this.nodeHeight + 10);
        ArrayList<NodeDiagram> nodeDiagrams = new ArrayList<NodeDiagram>();
        for (Node node : this.process.getNodes()) {
            NodeDiagram diagram = node.getDiagram();
            if (node.getSequenceFlows() != null && node.getSequenceFlows().size() > 0) {
                ArrayList<SequenceFlowDiagram> flowDiagrams = new ArrayList<SequenceFlowDiagram>();
                for (SequenceFlowImpl flow : node.getSequenceFlows()) {
                    flowDiagrams.add(flow.getDiagram());
                }
                diagram.setSequenceFlowDiagrams(flowDiagrams);
            }
            nodeDiagrams.add(diagram);
        }
        this.diagram.setNodeDiagrams(nodeDiagrams);
    }

    private void buildSize(Node targetNode) {
        List<SequenceFlowImpl> flows;
        NodeDiagram d = targetNode.getDiagram();
        if (d.getX() > this.width) {
            this.width = d.getX();
        }
        if (d.getY() > this.height) {
            this.height = d.getY();
        }
        if (d.getWidth() > this.nodeWidth) {
            this.nodeWidth = d.getWidth();
        }
        if (d.getHeight() > this.nodeHeight) {
            this.nodeHeight = d.getHeight();
        }
        if ((flows = targetNode.getSequenceFlows()) == null) {
            return;
        }
        for (SequenceFlowImpl flow : flows) {
            if (this.processedSequenceFLows.contains(flow)) continue;
            this.processedSequenceFLows.add(flow);
            SequenceFlowDiagram diagram = flow.getDiagram();
            this.buildPoint(diagram.getPoints());
            Node node = this.process.getNode(flow.getToNode());
            this.buildSize(node);
        }
    }

    private void buildPoint(List<Point> points) {
        if (points == null) {
            return;
        }
        for (Point p : points) {
            if (p.getX() > this.width) {
                this.width = p.getX();
            }
            if (p.getY() <= this.height) continue;
            this.height = p.getY();
        }
    }

    public ProcessDiagram getDiagram() {
        return this.diagram;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

