/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.parse;

import com.bstek.uflo.deploy.StringTools;
import com.bstek.uflo.deploy.parse.Parser;
import com.bstek.uflo.diagram.NodeDiagram;
import com.bstek.uflo.process.assign.Assignee;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.FormElement;
import com.bstek.uflo.process.node.Mapping;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.UserData;
import com.bstek.uflo.process.security.Authority;
import com.bstek.uflo.utils.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractParser
implements Parser,
ApplicationContextAware {
    protected Collection<Parser> parsers;

    protected String unescape(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return StringTools.unescape(str);
    }

    protected NodeDiagram parseDiagram(Element element) {
        BigDecimal bd;
        NodeDiagram diagram = new NodeDiagram();
        String g = element.attributeValue("g");
        String name = element.attributeValue("name");
        String label = element.attributeValue("label");
        diagram.setLabel(label);
        diagram.setName(name);
        if (StringUtils.isNotBlank((String)g)) {
            String[] info = g.split(",");
            if (info.length != 4) {
                throw new IllegalArgumentException("Node " + element.attributeValue("name") + " diagram info is invalide!");
            }
            BigDecimal x = Utils.toBigDecimal(info[0]);
            diagram.setX(x.intValue());
            BigDecimal y = Utils.toBigDecimal(info[1]);
            diagram.setY(y.intValue());
            BigDecimal w = Utils.toBigDecimal(info[2]);
            diagram.setWidth(w.intValue());
            BigDecimal h = Utils.toBigDecimal(info[3]);
            diagram.setHeight(h.intValue());
        }
        String x = element.attributeValue("x");
        String y = element.attributeValue("y");
        String width = element.attributeValue("width");
        String height = element.attributeValue("height");
        if (StringUtils.isNotBlank((String)x)) {
            bd = Utils.toBigDecimal(x);
            diagram.setX(bd.intValue());
        }
        if (StringUtils.isNotBlank((String)y)) {
            bd = Utils.toBigDecimal(y);
            diagram.setY(bd.intValue());
        }
        if (StringUtils.isNotBlank((String)width)) {
            bd = Utils.toBigDecimal(width);
            diagram.setWidth(bd.intValue());
        }
        if (StringUtils.isNotBlank((String)height)) {
            bd = Utils.toBigDecimal(height);
            diagram.setHeight(bd.intValue());
        }
        return diagram;
    }

    protected void parseNodeCommonInfo(Element element, Node node) {
        BigDecimal bd;
        StringTokenizer tokenizer;
        Element desc;
        node.setName(this.unescape(element.attributeValue("name")));
        String label = element.attributeValue("label");
        if (StringUtils.isNotEmpty((String)label)) {
            node.setLabel(this.unescape(label));
        }
        if ((desc = element.element("description")) != null) {
            node.setDescription(this.unescape(desc.getTextTrim()));
        }
        node.setEventHandlerBean(this.unescape(element.attributeValue("event-handler-bean")));
        int x = 0;
        int y = 0;
        int width = 80;
        int height = 40;
        String g = element.attributeValue("g");
        if (StringUtils.isNotBlank((String)g) && (tokenizer = new StringTokenizer(g, ",")).countTokens() == 4) {
            x = Integer.valueOf(tokenizer.nextToken());
            y = Integer.valueOf(tokenizer.nextToken());
            width = Integer.valueOf(tokenizer.nextToken());
            height = Integer.valueOf(tokenizer.nextToken());
        }
        node.setX(x);
        node.setY(y);
        node.setWidth(width);
        node.setHeight(height);
        String xAttr = element.attributeValue("x");
        String yAttr = element.attributeValue("y");
        String widthAttr = element.attributeValue("width");
        String heightAttr = element.attributeValue("height");
        if (StringUtils.isNotBlank((String)xAttr)) {
            bd = new BigDecimal(xAttr);
            node.setX(bd.intValue());
        }
        if (StringUtils.isNotBlank((String)yAttr)) {
            bd = new BigDecimal(yAttr);
            node.setY(bd.intValue());
        }
        if (StringUtils.isNotBlank((String)widthAttr)) {
            bd = new BigDecimal(widthAttr);
            node.setWidth(bd.intValue());
        }
        if (StringUtils.isNotBlank((String)heightAttr)) {
            bd = new BigDecimal(heightAttr);
            node.setHeight(bd.intValue());
        }
    }

    protected List<Assignee> parserAssignees(Element element) {
        ArrayList<Assignee> assignees = new ArrayList<Assignee>();
        for (Object obj : element.elements()) {
            Element ele;
            if (!(obj instanceof Element) || !(ele = (Element)obj).getName().equals("assignee")) continue;
            String id = this.unescape(ele.attributeValue("id"));
            String name = this.unescape(ele.attributeValue("name"));
            String providerId = this.unescape(ele.attributeValue("provider-id"));
            Assignee assignee = new Assignee();
            assignee.setId(id);
            assignee.setName(name);
            assignee.setProviderId(providerId);
            assignees.add(assignee);
        }
        return assignees;
    }

    protected List<UserData> parseUserData(Element element) {
        ArrayList<UserData> data = new ArrayList<UserData>();
        for (Object object : element.elements()) {
            Element ele;
            if (!(object instanceof Element) || !(ele = (Element)object).getName().equals("user-data")) continue;
            data.add(new UserData(ele.attributeValue("key"), ele.attributeValue("value")));
        }
        return data;
    }

    protected List<FormElement> parseFormElements(Element element) {
        ArrayList<FormElement> formElements = new ArrayList<FormElement>();
        for (Object object : element.elements()) {
            Element ele;
            if (!(object instanceof Element) || !(ele = (Element)object).getName().equals("form-element")) continue;
            FormElement formElement = new FormElement();
            formElement.setName(ele.attributeValue("name"));
            formElement.setCaption(ele.attributeValue("caption"));
            formElement.setDataType(ele.attributeValue("data-type"));
            formElement.setDefaultValue(ele.attributeValue("default-value"));
            formElement.setEditorType(ele.attributeValue("editor-type"));
            formElement.setRequired(Boolean.valueOf(ele.attributeValue("required")));
            formElement.setAuthority(Authority.valueOf(ele.attributeValue("authority")));
            ArrayList<Mapping> mappings = null;
            for (Object obj : ele.elements()) {
                Element mappingElement;
                if (!(obj instanceof Element) || !(mappingElement = (Element)obj).getName().equals("mapping")) continue;
                if (mappings == null) {
                    mappings = new ArrayList<Mapping>();
                }
                Mapping mapping = new Mapping();
                mapping.setKey(mappingElement.attributeValue("key"));
                mapping.setLabel(mappingElement.attributeValue("label"));
                mappings.add(mapping);
            }
            formElement.setMappings(mappings);
            formElements.add(formElement);
        }
        return formElements;
    }

    protected List<SequenceFlowImpl> parseFlowElement(Element element, long processId, boolean parseChildren) {
        ArrayList<SequenceFlowImpl> flows = new ArrayList<SequenceFlowImpl>();
        block0: for (Object obj : element.elements()) {
            if (!(obj instanceof Element)) continue;
            Element ele = (Element)obj;
            for (Parser parser : this.parsers) {
                if (!parser.support(ele)) continue;
                Object processElement = parser.parse(ele, processId, parseChildren);
                if (!(processElement instanceof SequenceFlowImpl)) continue block0;
                SequenceFlowImpl flow = (SequenceFlowImpl)processElement;
                flows.add(flow);
                continue block0;
            }
        }
        return flows;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parsers = applicationContext.getBeansOfType(Parser.class).values();
    }
}

