/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.deploy.impl;

import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.command.impl.DeployProcessCommand;
import com.bstek.uflo.command.impl.DeployProcessResourceCommand;
import com.bstek.uflo.deploy.ProcessDeployer;
import com.bstek.uflo.deploy.parse.impl.ProcessParser;
import com.bstek.uflo.deploy.validate.ProcessValidateException;
import com.bstek.uflo.deploy.validate.impl.ProcessValidator;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.utils.IDGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultProcessDeployer
implements ProcessDeployer {
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private ProcessValidator processValidator;
    private CommandService commandService;

    @Override
    public ProcessDefinition deploy(InputStream inputStream) {
        ProcessDefinition process = null;
        long processId = IDGenerator.getInstance().nextId();
        if (inputStream instanceof ZipInputStream) {
            ZipInputStream zipInputStream = (ZipInputStream)inputStream;
            process = this.deployZip(zipInputStream, processId);
        } else {
            process = this.deployFile(inputStream, null, processId, false);
        }
        return process;
    }

    @Override
    public ProcessDefinition deploy(InputStream inputStream, int version, long processId) {
        ProcessDefinition process = this.deployFile(inputStream, version, processId, true);
        return process;
    }

    private ProcessDefinition deployFile(InputStream inputStream, Integer version, long processId, boolean update) {
        ProcessDefinition process = null;
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            this.validateProcess(new ByteArrayInputStream(bytes));
            process = ProcessParser.parseProcess(bytes, processId, update);
            process.setCreateDate(new Date());
            if (update) {
                process.setVersion(version);
            }
            this.commandService.executeCommand(new DeployProcessCommand(process, update));
            this.commandService.executeCommand(new DeployProcessResourceCommand(bytes, process.getName() + ".uflo.xml", processId, update));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return process;
    }

    private ProcessDefinition deployZip(ZipInputStream zipInputStream, long processId) {
        ProcessDefinition process = null;
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                byte[] bytes;
                String entryName = zipEntry.getName();
                if (entryName.endsWith(".uflo.xml")) {
                    bytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    this.validateProcess(new ByteArrayInputStream(bytes));
                    process = ProcessParser.parseProcess(bytes, processId, false);
                    this.commandService.executeCommand(new DeployProcessCommand(process, false));
                    this.commandService.executeCommand(new DeployProcessResourceCommand(bytes, entryName, processId, false));
                } else if (entryName.endsWith(".png")) {
                    bytes = IOUtils.toByteArray((InputStream)zipInputStream);
                    this.commandService.executeCommand(new DeployProcessResourceCommand(bytes, entryName, processId, false));
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)zipInputStream);
        }
        return process;
    }

    private void validateProcess(InputStream inputStream) {
        StringBuffer errorInfo = new StringBuffer();
        try {
            Document document = this.documentBuilderFactory.newDocumentBuilder().parse(inputStream);
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> nodeNames = new ArrayList<String>();
            Element element = document.getDocumentElement();
            if (this.processValidator.support(element)) {
                this.processValidator.validate(element, errors, nodeNames);
                if (errors.size() > 0) {
                    for (int i = 0; i < errors.size(); ++i) {
                        errorInfo.append(i + 1 + "." + (String)errors.get(i) + "\r\r");
                    }
                }
            } else {
                errorInfo.append("\u5f53\u524dXML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684UFLO\u6d41\u7a0b\u6a21\u7248\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String msg = errorInfo.toString();
        if (StringUtils.isNotEmpty((String)msg)) {
            throw new ProcessValidateException(msg);
        }
    }

    public void setProcessValidator(ProcessValidator processValidator) {
        this.processValidator = processValidator;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }
}

