/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl.jump;

import com.bstek.uflo.command.impl.jump.JumpNode;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.process.flow.SequenceFlow;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.DecisionNode;
import com.bstek.uflo.process.node.ForeachNode;
import com.bstek.uflo.process.node.ForkNode;
import com.bstek.uflo.process.node.JoinNode;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.process.node.TaskNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JumpNodeBuilder {
    private ProcessDefinition process;
    private List<SequenceFlow> flowStore = new ArrayList<SequenceFlow>();
    private Map<String, JumpNode> maps = new HashMap<String, JumpNode>();

    public JumpNodeBuilder(ProcessDefinition process) {
        this.process = process;
    }

    public Map<String, JumpNode> buildSimulationTasks() {
        StartNode node = this.process.getStartNode();
        JumpNode jumpNode = new JumpNode(node.getName());
        jumpNode.setTask(true);
        jumpNode.setLevel(1);
        jumpNode.setLabel(node.getLabel());
        this.maps.put(jumpNode.getName(), jumpNode);
        this.simulation(node, jumpNode);
        return this.maps;
    }

    private void simulation(Node parentNode, JumpNode jumpNode) {
        List<SequenceFlowImpl> flows = parentNode.getSequenceFlows();
        if (flows == null || flows.size() == 0) {
            return;
        }
        for (SequenceFlow sequenceFlow : flows) {
            if (this.flowStore.contains(sequenceFlow)) continue;
            this.flowStore.add(sequenceFlow);
            String to = sequenceFlow.getToNode();
            Node toNode = this.process.getNode(to);
            JumpNode nextJumpNode = new JumpNode(toNode.getName());
            nextJumpNode.setLabel(toNode.getLabel());
            if (jumpNode.getParent().size() > 0) {
                nextJumpNode.getParent().addAll(jumpNode.getParent());
            }
            if (parentNode instanceof ForkNode || parentNode instanceof ForeachNode) {
                nextJumpNode.setLevel(jumpNode.getLevel() + 1);
                nextJumpNode.addParent(parentNode.getName() + "-" + sequenceFlow.getName());
            } else if (parentNode instanceof JoinNode) {
                nextJumpNode.decreaseParent();
                nextJumpNode.setLevel(jumpNode.getLevel() - 1);
            } else {
                nextJumpNode.setLevel(jumpNode.getLevel());
            }
            if (!(this.maps.containsKey(nextJumpNode.getName()) || toNode instanceof ForkNode || toNode instanceof JoinNode || toNode instanceof ForeachNode || toNode instanceof DecisionNode)) {
                this.maps.put(nextJumpNode.getName(), nextJumpNode);
            }
            if (toNode instanceof TaskNode) {
                nextJumpNode.setTask(true);
            }
            this.simulation(toNode, nextJumpNode);
        }
    }
}

