/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.impl.SaveHistoryProcessInstanceCommand;
import com.bstek.uflo.command.impl.SaveProcessInstanceVariablesCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import com.bstek.uflo.process.handler.ProcessEventHandler;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.service.StartProcessInfo;
import com.bstek.uflo.utils.IDGenerator;
import com.bstek.uflo.utils.ProcessListenerUtils;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class StartProcessInstanceCommand
implements Command<ProcessInstance> {
    private ProcessDefinition process;
    private Map<String, Object> variables;
    private StartProcessInfo startProcessInfo;
    private long parentProcessInstanceId;

    public StartProcessInstanceCommand(ProcessDefinition process, Map<String, Object> variables, StartProcessInfo startProcessInfo, long parentProcessInstanceId) {
        this.process = process;
        this.variables = variables;
        this.startProcessInfo = startProcessInfo;
        this.parentProcessInstanceId = parentProcessInstanceId;
    }

    @Override
    public ProcessInstance execute(Context context) {
        ProcessInstance processInstance = new ProcessInstance();
        long piId = IDGenerator.getInstance().nextId();
        processInstance.addMetadata(StartProcessInfo.KEY, this.startProcessInfo);
        processInstance.setId(piId);
        processInstance.setRootId(piId);
        processInstance.setState(ProcessInstanceState.Start);
        processInstance.setProcessId(this.process.getId());
        processInstance.setCreateDate(new Date());
        processInstance.setPromoter(this.startProcessInfo.getPromoter());
        processInstance.setBusinessId(this.startProcessInfo.getBusinessId());
        processInstance.setSubject(this.startProcessInfo.getSubject());
        processInstance.setTag(this.startProcessInfo.getTag());
        if (this.parentProcessInstanceId > 0L) {
            processInstance.setParentId(this.parentProcessInstanceId);
        }
        processInstance.setHistoryProcessInstanceId(IDGenerator.getInstance().nextId());
        if (this.variables != null && this.variables.size() > 0) {
            context.getCommandService().executeCommand(new SaveProcessInstanceVariablesCommand(processInstance, this.variables));
        }
        context.getExpressionContext().createContext(processInstance, this.variables);
        StartNode startNode = this.process.getStartNode();
        processInstance.setCurrentTask(startNode.getName());
        context.getSession().save((Object)processInstance);
        context.getCommandService().executeCommand(new SaveHistoryProcessInstanceCommand(processInstance));
        processInstance.setCurrentNode(startNode.getName());
        ProcessListenerUtils.fireProcessStartListers(processInstance, context);
        String processEventHandlerBean = this.process.getEventHandlerBean();
        if (StringUtils.isNotEmpty((String)processEventHandlerBean)) {
            ProcessEventHandler bean = (ProcessEventHandler)context.getApplicationContext().getBean(processEventHandlerBean);
            bean.start(processInstance, context);
        }
        startNode.createActivityHistory(context, processInstance);
        boolean isLeave = startNode.enter(context, processInstance);
        startNode.doEnterEventHandler(context, processInstance);
        if (isLeave) {
            startNode.leave(context, processInstance, this.startProcessInfo.getSequenceFlowName());
        }
        return processInstance;
    }
}

