/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.CommandService;
import com.bstek.uflo.env.EnvironmentProvider;
import com.bstek.uflo.env.impl.ContextImpl;
import com.bstek.uflo.expr.ExpressionContext;
import com.bstek.uflo.service.IdentityService;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.TaskService;
import com.bstek.uflo.utils.EnvironmentUtils;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionCommandService
implements CommandService,
ApplicationContextAware {
    private ContextImpl context;
    private SessionFactory sessionFactory;
    private PlatformTransactionManager platformTransactionManager;
    private int springPropagationBehaviour = 0;
    private int newSpringPropagationBehaviour = 3;

    @Override
    public <T> T executeCommand(final Command<T> command) {
        TransactionTemplate template = new TransactionTemplate(this.platformTransactionManager);
        template.setPropagationBehavior(this.springPropagationBehaviour);
        return (T)template.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                return command.execute(SpringTransactionCommandService.this.context);
            }
        });
    }

    @Override
    public <T> T executeCommandInNewTransaction(final Command<T> command) {
        TransactionTemplate template = new TransactionTemplate(this.platformTransactionManager);
        template.setPropagationBehavior(this.newSpringPropagationBehaviour);
        return (T)template.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                return command.execute(SpringTransactionCommandService.this.context);
            }
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.platformTransactionManager = EnvironmentUtils.getEnvironment().getPlatformTransactionManager();
        if (this.platformTransactionManager == null) {
            throw new RuntimeException("The " + EnvironmentProvider.class.getName() + " implements class's method 'getPlatformTransactionManager' can not return null.");
        }
        this.sessionFactory = EnvironmentUtils.getEnvironment().getSessionFactory();
        if (this.sessionFactory == null) {
            throw new RuntimeException("The " + EnvironmentProvider.class.getName() + " implements class's method 'getSessionFactory' can not return null.");
        }
        this.context = new ContextImpl();
        this.context.setCommandService(this);
        this.context.setApplicationContext(applicationContext);
        this.context.setSessionFactory(this.sessionFactory);
        this.context.setProcessService((ProcessService)applicationContext.getBean("uflo.processService"));
        this.context.setExpressionContext((ExpressionContext)applicationContext.getBean("uflo.expressionContext"));
        this.context.setIdentityService((IdentityService)applicationContext.getBean("uflo.identityService"));
        this.context.setTaskService((TaskService)applicationContext.getBean("uflo.taskService"));
    }
}

