/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskAppointor;
import com.bstek.uflo.utils.IDGenerator;
import org.hibernate.Query;
import org.hibernate.Session;

public class SaveTaskAppointorCommand
implements Command<Object> {
    private Task task;
    private String taskNodeName;
    private String[] assignees;

    public SaveTaskAppointorCommand(Task task, String taskNodeName, String[] assignees) {
        this.task = task;
        this.taskNodeName = taskNodeName;
        this.assignees = assignees;
    }

    @Override
    public Object execute(Context context) {
        Session session = context.getSession();
        Query query = session.createQuery("delete " + TaskAppointor.class.getName() + " where taskNodeName=:nodeName and processInstanceId=:processInstanceId");
        query.setString("nodeName", this.taskNodeName).setLong("processInstanceId", this.task.getRootProcessInstanceId()).executeUpdate();
        for (String assignee : this.assignees) {
            TaskAppointor appointor = new TaskAppointor();
            appointor.setId(IDGenerator.getInstance().nextId());
            appointor.setAppointor(this.task.getAssignee());
            appointor.setOwner(assignee);
            appointor.setAppointorNode(this.task.getNodeName());
            appointor.setProcessInstanceId(this.task.getRootProcessInstanceId());
            appointor.setTaskNodeName(this.taskNodeName);
            session.save((Object)appointor);
        }
        return null;
    }
}

