/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.variable.BlobVariable;
import com.bstek.uflo.model.variable.TextVariable;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.query.impl.ProcessVariableQueryImpl;
import com.bstek.uflo.utils.IDGenerator;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;

public class SaveProcessInstanceVariablesCommand
implements Command<Object> {
    private Map<String, Object> variables;
    private ProcessInstance processInstance;

    public SaveProcessInstanceVariablesCommand(ProcessInstance processInstance, Map<String, Object> variables) {
        this.processInstance = processInstance;
        this.variables = variables;
    }

    @Override
    public Object execute(Context context) {
        Session session = context.getSession();
        for (String key : this.variables.keySet()) {
            Variable var2;
            ProcessVariableQueryImpl query = new ProcessVariableQueryImpl(context.getCommandService());
            query.processInstanceId(this.processInstance.getId());
            query.key(key);
            List oldVars = (List)query.list();
            for (Variable var2 : oldVars) {
                session.delete((Object)var2);
                if (var2 instanceof TextVariable) {
                    session.delete((Object)((TextVariable)var2).getBlob());
                }
                if (!(var2 instanceof BlobVariable)) continue;
                session.delete((Object)((BlobVariable)var2).getBlob());
            }
            Object obj = this.variables.get(key);
            if (obj == null) {
                throw new IllegalArgumentException("Variable [" + key + "] value can not be null.");
            }
            var2 = Variable.newVariable(obj, context);
            var2.setId(IDGenerator.getInstance().nextId());
            var2.setKey(key);
            var2.setProcessInstanceId(this.processInstance.getId());
            var2.setRootProcessInstanceId(this.processInstance.getRootId());
            context.getExpressionContext().addContextVariables(this.processInstance, this.variables);
            session.save((Object)var2);
        }
        return null;
    }
}

