/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryTask;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.utils.EnvironmentUtils;
import com.bstek.uflo.utils.IDGenerator;
import java.util.Date;
import org.hibernate.Session;

public class SaveHistoryTaskCommand
implements Command<HistoryTask> {
    private Task task;
    private ProcessInstance processInstance;

    public SaveHistoryTaskCommand(Task task, ProcessInstance processInstance) {
        this.task = task;
        this.processInstance = processInstance;
    }

    @Override
    public HistoryTask execute(Context context) {
        Session session = context.getSession();
        HistoryTask hisTask = new HistoryTask();
        hisTask.setId(IDGenerator.getInstance().nextId());
        hisTask.setDescription(this.task.getDescription());
        hisTask.setProcessId(this.task.getProcessId());
        hisTask.setHistoryProcessInstanceId(this.processInstance.getHistoryProcessInstanceId());
        hisTask.setCreateDate(this.task.getCreateDate());
        hisTask.setProcessInstanceId(this.processInstance.getRootId());
        hisTask.setRootProcessInstanceId(this.processInstance.getRootId());
        hisTask.setTaskName(this.task.getTaskName());
        hisTask.setAssignee(this.task.getAssignee());
        hisTask.setNodeName(this.task.getNodeName());
        hisTask.setState(this.task.getState());
        String loginUser = EnvironmentUtils.getEnvironment().getLoginUser();
        if (loginUser != null && loginUser.equals(this.task.getAssignee())) {
            hisTask.setEndDate(new Date());
            hisTask.setOpinion(this.task.getOpinion());
        }
        hisTask.setCreateDate(this.task.getCreateDate());
        hisTask.setBusinessId(this.task.getBusinessId());
        hisTask.setDuedate(this.task.getDuedate());
        hisTask.setOwner(this.task.getOwner());
        hisTask.setType(this.task.getType());
        hisTask.setUrl(this.task.getUrl());
        hisTask.setTaskId(this.task.getId());
        hisTask.setSubject(this.task.getSubject());
        session.save((Object)hisTask);
        return hisTask;
    }
}

