/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryProcessInstance;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import java.util.Date;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class SaveHistoryProcessInstanceCommand
implements Command<HistoryProcessInstance> {
    private ProcessInstance processInstance;

    public SaveHistoryProcessInstanceCommand(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @Override
    public HistoryProcessInstance execute(Context context) {
        Session session = context.getSession();
        HistoryProcessInstance hisProcessInstance = null;
        if (this.processInstance.getState().equals((Object)ProcessInstanceState.Start)) {
            hisProcessInstance = new HistoryProcessInstance();
            hisProcessInstance.setId(this.processInstance.getHistoryProcessInstanceId());
            hisProcessInstance.setCreateDate(this.processInstance.getCreateDate());
            hisProcessInstance.setProcessId(this.processInstance.getProcessId());
            hisProcessInstance.setProcessInstanceId(this.processInstance.getId());
            hisProcessInstance.setTag(this.processInstance.getTag());
            hisProcessInstance.setBusinessId(this.processInstance.getBusinessId());
            hisProcessInstance.setPromoter(this.processInstance.getPromoter());
            hisProcessInstance.setSubject(this.processInstance.getSubject());
            session.save((Object)hisProcessInstance);
        }
        if (this.processInstance.getState().equals((Object)ProcessInstanceState.End)) {
            hisProcessInstance = (HistoryProcessInstance)session.createCriteria(HistoryProcessInstance.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)this.processInstance.getId())).uniqueResult();
            hisProcessInstance.setEndDate(new Date());
            session.update((Object)hisProcessInstance);
        }
        return hisProcessInstance;
    }
}

