/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryActivity;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.utils.IDGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class SaveHistoryActivityCommand
implements Command<HistoryActivity> {
    private ProcessInstance processInstance;
    private Node node;
    private boolean isEnd;
    private String leaveFlowName;

    public SaveHistoryActivityCommand(ProcessInstance processInstance, Node node, boolean isEnd, String leaveFlowName) {
        this.processInstance = processInstance;
        this.node = node;
        this.isEnd = isEnd;
        this.leaveFlowName = leaveFlowName;
    }

    @Override
    public HistoryActivity execute(Context context) {
        Session session = context.getSession();
        HistoryActivity hisActivity = (HistoryActivity)session.createCriteria(HistoryActivity.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)this.processInstance.getId())).add(Restrictions.isNull((String)"endDate")).add((Criterion)Restrictions.eq((String)"nodeName", (Object)this.node.getName())).uniqueResult();
        if (this.isEnd) {
            List historyActivities;
            if (hisActivity == null && (historyActivities = session.createCriteria(HistoryActivity.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)this.processInstance.getId())).add(Restrictions.isNotNull((String)"endDate")).addOrder(Order.desc((String)"createDate")).add((Criterion)Restrictions.eq((String)"nodeName", (Object)this.node.getName())).list()).size() > 0) {
                hisActivity = (HistoryActivity)historyActivities.get(0);
            }
            if (hisActivity == null) {
                return null;
            }
            hisActivity.setEndDate(new Date());
            if (StringUtils.isNotEmpty((String)this.leaveFlowName)) {
                hisActivity.setLeaveFlowName(this.leaveFlowName);
            }
        } else if (hisActivity == null) {
            hisActivity = new HistoryActivity();
            hisActivity.setCreateDate(new Date());
            hisActivity.setHistoryProcessInstanceId(this.processInstance.getHistoryProcessInstanceId());
            hisActivity.setNodeName(this.node.getName());
            hisActivity.setId(IDGenerator.getInstance().nextId());
            hisActivity.setDescription(this.node.getDescription());
            hisActivity.setProcessId(this.node.getProcessId());
            hisActivity.setRootProcessInstanceId(this.processInstance.getRootId());
            hisActivity.setProcessInstanceId(this.processInstance.getId());
            hisActivity.setLeaveFlowName(this.leaveFlowName);
        }
        session.saveOrUpdate((Object)hisActivity);
        return hisActivity;
    }
}

