/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.variable.BlobVariable;
import com.bstek.uflo.model.variable.TextVariable;
import com.bstek.uflo.model.variable.Variable;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class GetProcessInstanceVariableCommand
implements Command<Variable> {
    private ProcessInstance processInstance;
    private String key;

    public GetProcessInstanceVariableCommand(String key, ProcessInstance processInstance) {
        this.processInstance = processInstance;
        this.key = key;
    }

    @Override
    public Variable execute(Context context) {
        return this.getVariable(context, this.processInstance);
    }

    private Variable getVariable(Context context, ProcessInstance pi) {
        Session session = context.getSession();
        Criteria criteria = session.createCriteria(Variable.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)pi.getId())).add((Criterion)Restrictions.eq((String)"key", (Object)this.key));
        List vars = criteria.list();
        if (vars.size() == 0) {
            if (pi.getParentId() > 0L) {
                ProcessInstance parentInstance = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)Long.valueOf(pi.getParentId()));
                return this.getVariable(context, parentInstance);
            }
            return null;
        }
        for (Variable var : vars) {
            if (var instanceof BlobVariable) {
                ((BlobVariable)var).initValue(context);
            }
            if (!(var instanceof TextVariable)) continue;
            ((TextVariable)var).initValue(context);
        }
        return (Variable)vars.get(0);
    }
}

