/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.deploy.parse.impl.ProcessParser;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.Blob;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class GetProcessCommand
implements Command<ProcessDefinition> {
    private long processId;
    private String processName;
    private int version;
    private String categoryId;

    public GetProcessCommand(long processId, String processName, int version, String categoryId) {
        this.processId = processId;
        this.processName = processName;
        this.version = version;
        this.categoryId = categoryId;
    }

    @Override
    public ProcessDefinition execute(Context context) {
        Session session = context.getSession();
        if (this.processId > 0L) {
            ProcessDefinition p = (ProcessDefinition)session.get(ProcessDefinition.class, (Serializable)Long.valueOf(this.processId));
            return this.parseProcess(p.getId(), p.getVersion(), p.getName(), session);
        }
        if (StringUtils.isNotEmpty((String)this.processName)) {
            Criteria criteria = session.createCriteria(ProcessDefinition.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.processName)).addOrder(Order.desc((String)"version"));
            if (this.categoryId == null) {
                this.categoryId = EnvironmentUtils.getEnvironment().getCategoryId();
            }
            if (StringUtils.isNotEmpty((String)this.categoryId)) {
                criteria.add((Criterion)Restrictions.eq((String)"categoryId", (Object)this.categoryId));
            }
            if (this.version > 0) {
                criteria.add((Criterion)Restrictions.eq((String)"version", (Object)this.version));
                List processes = criteria.list();
                if (processes.size() > 0) {
                    ProcessDefinition p = (ProcessDefinition)processes.get(0);
                    return this.parseProcess(p.getId(), p.getVersion(), p.getName(), session);
                }
            } else {
                List processes = criteria.list();
                for (ProcessDefinition process : processes) {
                    Date effectDate = process.getEffectDate();
                    if (effectDate == null) {
                        return this.parseProcess(process.getId(), process.getVersion(), process.getName(), session);
                    }
                    if (new Date().getTime() <= effectDate.getTime()) continue;
                    return this.parseProcess(process.getId(), process.getVersion(), process.getName(), session);
                }
            }
        }
        return null;
    }

    private ProcessDefinition parseProcess(long processId, int version, String processName, Session session) {
        String hql = "from " + Blob.class.getName() + " where processId=:processId and name=:name";
        Blob blob = (Blob)session.createQuery(hql).setLong("processId", processId).setString("name", processName + ".uflo.xml").uniqueResult();
        try {
            ProcessDefinition process = ProcessParser.parseProcess(blob.getBlobValue(), processId, true);
            process.setId(processId);
            process.setVersion(version);
            return process;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

