/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.deploy.parse.impl.ProcessParser;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.Blob;
import com.bstek.uflo.model.ProcessDefinition;
import org.hibernate.Session;

public class GetProcessByKeyCommand
implements Command<ProcessDefinition> {
    private String processKey;

    public GetProcessByKeyCommand(String processKey) {
        this.processKey = processKey;
    }

    @Override
    public ProcessDefinition execute(Context context) {
        Session session = context.getSession();
        ProcessDefinition p = (ProcessDefinition)session.createQuery("from " + ProcessDefinition.class.getName() + " where key=:key").setString("key", this.processKey).uniqueResult();
        if (p == null) {
            return null;
        }
        return this.parseProcess(p.getId(), p.getName(), session);
    }

    private ProcessDefinition parseProcess(long processId, String processName, Session session) {
        String hql = "from " + Blob.class.getName() + " where processId=:processId and name=:name";
        Blob blob = (Blob)session.createQuery(hql).setLong("processId", processId).setString("name", processName + ".uflo.xml").uniqueResult();
        try {
            ProcessDefinition process = ProcessParser.parseProcess(blob.getBlobValue(), processId, true);
            process.setId(processId);
            return process;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

