/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.impl.jump.JumpNode;
import com.bstek.uflo.command.impl.jump.JumpNodeBuilder;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GetJumpAvaliableTaskNodesCommand
implements Command<List<JumpNode>> {
    private Task task;

    public GetJumpAvaliableTaskNodesCommand(Task task) {
        this.task = task;
    }

    @Override
    public List<JumpNode> execute(Context context) {
        ProcessDefinition process = context.getProcessService().getProcessById(this.task.getProcessId());
        JumpNodeBuilder builder = new JumpNodeBuilder(process);
        Map<String, JumpNode> map = builder.buildSimulationTasks();
        JumpNode node = map.get(this.task.getNodeName());
        ArrayList<JumpNode> list = new ArrayList<JumpNode>();
        int level = node.getLevel();
        for (JumpNode jumpNode : map.values()) {
            if (jumpNode.getLevel() != level || !this.parentEquals(node.getParent(), jumpNode.getParent()) || jumpNode.getName().equals(node.getName())) continue;
            list.add(jumpNode);
        }
        return list;
    }

    private boolean parentEquals(List<String> a, List<String> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            String name = a.get(i);
            if (name.equals(b.get(i))) continue;
            return false;
        }
        return true;
    }
}

