/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.ForeachNode;
import com.bstek.uflo.process.node.ForkNode;
import com.bstek.uflo.process.node.JoinNode;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.process.node.SubprocessNode;
import com.bstek.uflo.process.node.TaskNode;
import java.util.ArrayList;
import java.util.List;

public class GetAvaliableAppointAssigneeTaskNodes
implements Command<List<String>> {
    public Task task;

    public GetAvaliableAppointAssigneeTaskNodes(Task task) {
        this.task = task;
    }

    @Override
    public List<String> execute(Context context) {
        ProcessDefinition pd = context.getProcessService().getProcessById(this.task.getProcessId());
        Node node = pd.getNode(this.task.getNodeName());
        ArrayList<String> nodes = new ArrayList<String>();
        this.getAvliableNodes(node, nodes, pd);
        return nodes;
    }

    private void getAvliableNodes(Node node, List<String> nodes, ProcessDefinition pd) {
        List<SequenceFlowImpl> flows = node.getSequenceFlows();
        if (flows == null || flows.size() == 0) {
            return;
        }
        for (SequenceFlowImpl flow : flows) {
            Node toNode = pd.getNode(flow.getToNode());
            if (toNode instanceof StartNode || toNode instanceof JoinNode || toNode instanceof ForeachNode || toNode instanceof SubprocessNode || toNode instanceof ForkNode) continue;
            if (toNode instanceof TaskNode) {
                TaskNode taskNode = (TaskNode)toNode;
                if (!taskNode.isAllowSpecifyAssignee()) continue;
                nodes.add(toNode.getName());
                continue;
            }
            this.getAvliableNodes(toNode, nodes, pd);
        }
    }
}

