/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.impl.SaveHistoryTaskCommand;
import com.bstek.uflo.command.impl.SaveProcessInstanceVariablesCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.TaskOpinion;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ForwardTaskCommand
implements Command<Task> {
    private Task task;
    private String jumpTargetNodeName;
    private Map<String, Object> variables;
    private TaskOpinion opinion;
    private TaskState state;

    public ForwardTaskCommand(Task task, String jumpTargetNodeName, Map<String, Object> variables, TaskOpinion opinion, TaskState state) {
        this.task = task;
        this.opinion = opinion;
        this.jumpTargetNodeName = jumpTargetNodeName;
        this.variables = variables;
        this.state = state;
    }

    @Override
    public Task execute(Context context) {
        ProcessService processService = context.getProcessService();
        ProcessDefinition processDefinition = processService.getProcessById(this.task.getProcessId());
        Node targetNode = processDefinition.getNode(this.jumpTargetNodeName);
        if (targetNode == null) {
            throw new IllegalArgumentException("Target node " + this.jumpTargetNodeName + " is not exist!");
        }
        Node taskNode = processDefinition.getNode(this.task.getNodeName());
        String targetFlowName = null;
        List<SequenceFlowImpl> flows = taskNode.getSequenceFlows();
        for (SequenceFlowImpl flow : flows) {
            if (!flow.getToNode().equals(this.jumpTargetNodeName)) continue;
            targetFlowName = flow.getName();
            break;
        }
        if (targetFlowName == null) {
            targetFlowName = "__temp_flow_" + UUID.randomUUID().toString();
            SequenceFlowImpl newFlow = new SequenceFlowImpl();
            newFlow.setToNode(this.jumpTargetNodeName);
            newFlow.setName(targetFlowName);
            newFlow.setProcessId(this.task.getProcessId());
            flows.add(newFlow);
        }
        ProcessInstance processInstance = processService.getProcessInstanceById(this.task.getProcessInstanceId());
        if (this.variables != null && this.variables.size() > 0) {
            context.getExpressionContext().addContextVariables(processInstance, this.variables);
            context.getCommandService().executeCommand(new SaveProcessInstanceVariablesCommand(processInstance, this.variables));
        }
        if (this.opinion != null) {
            this.task.setOpinion(this.opinion.getOpinion());
        }
        this.task.setEndDate(new Date());
        this.task.setState(this.state);
        context.getSession().update((Object)this.task);
        context.getCommandService().executeCommand(new SaveHistoryTaskCommand(this.task, processInstance));
        taskNode.leave(context, processInstance, targetFlowName);
        return this.task;
    }
}

