/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.ProcessInstanceState;
import com.bstek.uflo.process.node.EndNode;
import java.io.Serializable;
import org.hibernate.Session;

public class ExecuteEndNodeCommand
implements Command<Object> {
    private EndNode endNode;
    private ProcessInstance processInstance;

    public ExecuteEndNodeCommand(EndNode endNode, ProcessInstance processInstance) {
        this.endNode = endNode;
        this.processInstance = processInstance;
    }

    @Override
    public Object execute(Context context) {
        Session session = context.getSession();
        this.processInstance.setState(ProcessInstanceState.End);
        session.delete((Object)this.processInstance);
        if (this.endNode.isTerminate()) {
            this.removeProcessInstances(this.processInstance, session);
        }
        return null;
    }

    private void removeProcessInstances(ProcessInstance pi, Session session) {
        long pid = pi.getParentId();
        if (pid > 0L) {
            ProcessInstance parent = (ProcessInstance)session.get(ProcessInstance.class, (Serializable)Long.valueOf(pid));
            parent.setState(ProcessInstanceState.End);
            session.delete((Object)parent);
            this.removeProcessInstances(parent, session);
        }
    }
}

