/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class DeployProcessCommand
implements Command<ProcessDefinition> {
    private ProcessDefinition process;
    private boolean update = false;

    public DeployProcessCommand(ProcessDefinition process, boolean update) {
        this.process = process;
        this.update = update;
    }

    @Override
    public ProcessDefinition execute(Context context) {
        int size;
        Session session = context.getSession();
        String key = this.process.getKey();
        if (!this.update && StringUtils.isNotEmpty((String)key) && (size = session.createCriteria(ProcessDefinition.class).add((Criterion)Restrictions.eq((String)"key", (Object)key)).list().size()) > 0) {
            throw new IllegalArgumentException("Process definition " + this.process.getName() + "'s key " + key + " is not the only one!");
        }
        int newVersion = 1;
        if (!this.update) {
            List processes = session.createCriteria(ProcessDefinition.class).add((Criterion)Restrictions.eq((String)"name", (Object)this.process.getName())).addOrder(Order.desc((String)"version")).list();
            if (processes.size() > 0) {
                newVersion = ((ProcessDefinition)processes.get(0)).getVersion() + 1;
                this.process.setVersion(newVersion);
            } else {
                this.process.setVersion(newVersion);
            }
        }
        if (StringUtils.isEmpty((String)key)) {
            key = this.process.getName() + "-" + newVersion;
            this.process.setKey(key);
        }
        if (this.update) {
            session.update((Object)this.process);
        } else {
            session.save((Object)this.process);
        }
        return this.process;
    }
}

