/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryTask;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskParticipator;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.service.SchedulerService;
import java.util.List;
import org.hibernate.Session;

public class DeleteTaskByNodeCommand
implements Command<Integer> {
    private long processInstanceId;
    private String nodeName;

    public DeleteTaskByNodeCommand(long processInstanceId, String nodeName) {
        this.processInstanceId = processInstanceId;
        this.nodeName = nodeName;
    }

    @Override
    public Integer execute(Context context) {
        Session session = context.getSession();
        String hql = "from " + Task.class.getName() + " where nodeName=:nodeName and (processInstanceId=:processInstanceId or rootProcessInstanceId=:rootProcessInstanceId)";
        List list = session.createQuery(hql).setString("nodeName", this.nodeName).setLong("processInstanceId", this.processInstanceId).setLong("rootProcessInstanceId", this.processInstanceId).list();
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        for (Task task : list) {
            if (task.getType().equals((Object)TaskType.Participative)) {
                session.createQuery("delete " + TaskParticipator.class.getName() + " where taskId=:taskId").setLong("taskId", task.getId()).executeUpdate();
            }
            hql = "delete " + HistoryTask.class.getName() + " where taskId=:taskId";
            session.createQuery(hql).setLong("taskId", task.getId()).executeUpdate();
            session.delete((Object)task);
            schedulerService.removeReminderJob(task);
        }
        return list.size();
    }
}

