/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.HistoryActivity;
import com.bstek.uflo.model.HistoryTask;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskParticipator;
import com.bstek.uflo.model.variable.Variable;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.service.SchedulerService;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class DeleteProcessInstanceCommand
implements Command<Object> {
    private ProcessInstance processInstance;

    public DeleteProcessInstanceCommand(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @Override
    public Object execute(Context context) {
        ProcessDefinition process = context.getProcessService().getProcessById(this.processInstance.getProcessId());
        this.deleteProcessInstance(context, this.processInstance, process);
        return null;
    }

    public Object deleteProcessInstance(Context context, ProcessInstance pi, ProcessDefinition process) {
        Node currentNode;
        Session session = context.getSession();
        List instances = session.createQuery("from " + ProcessInstance.class.getName() + " where parentId=:parentId").setLong("parentId", pi.getId()).list();
        for (ProcessInstance instance : instances) {
            ProcessDefinition subProcess = context.getProcessService().getProcessById(instance.getProcessId());
            this.deleteProcessInstance(context, instance, subProcess);
            session.createQuery("delete " + Variable.class.getName() + " where processInstanceId=:pIId").setLong("pIId", instance.getId()).executeUpdate();
        }
        session.createQuery("delete " + Variable.class.getName() + " where processInstanceId=:processInstanceId or rootProcessInstanceId=:rootId").setLong("processInstanceId", pi.getId()).setLong("rootId", pi.getRootId()).executeUpdate();
        String currentNodeName = pi.getCurrentNode();
        if (StringUtils.isNotBlank((String)currentNodeName) && (currentNode = process.getNode(currentNodeName)) != null && !(currentNode instanceof TaskNode)) {
            currentNode.cancel(context, pi);
        }
        session.createQuery("delete " + HistoryTask.class.getName() + " where processInstanceId=:processInstanceId or rootProcessInstanceId=:rootId").setLong("processInstanceId", pi.getId()).setLong("rootId", pi.getRootId()).executeUpdate();
        session.createQuery("delete " + HistoryActivity.class.getName() + " where processInstanceId=:processInstanceId or rootProcessInstanceId=:rootId").setLong("processInstanceId", pi.getId()).setLong("rootId", pi.getRootId()).executeUpdate();
        List tasks = session.createCriteria(Task.class).add((Criterion)Restrictions.eq((String)"processInstanceId", (Object)pi.getId())).list();
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        for (Task task : tasks) {
            schedulerService.removeReminderJob(task);
            session.createQuery("delete " + TaskParticipator.class.getName() + " where taskId=:taskId").setLong("taskId", task.getId()).executeUpdate();
            session.delete((Object)task);
        }
        session.delete((Object)pi);
        context.getExpressionContext().removeContext(pi);
        return null;
    }
}

