/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.impl.SaveHistoryTaskCommand;
import com.bstek.uflo.command.impl.SaveProcessInstanceVariablesCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.process.listener.TaskListener;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.process.node.reminder.DueDefinition;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.service.TaskOpinion;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class CompleteTaskCommand
implements Command<Task> {
    private Task task;
    private String flowName;
    private TaskOpinion opinion;
    private Map<String, Object> variables;

    public CompleteTaskCommand(Task task, String flowName, TaskOpinion opinion, Map<String, Object> variables) {
        this.task = task;
        this.opinion = opinion;
        this.flowName = flowName;
        this.variables = variables;
    }

    @Override
    public Task execute(Context context) {
        TaskState state = this.task.getState();
        if (!(state.equals((Object)TaskState.InProgress) || state.equals((Object)TaskState.Forwarded) || state.equals((Object)TaskState.Rollback) || state.equals((Object)TaskState.Withdraw))) {
            throw new IllegalStateException("Please change task state to inProgress first!");
        }
        if (state.equals((Object)TaskState.InProgress)) {
            this.task.setProgress(100);
        }
        this.task.setState(TaskState.Completed);
        this.task.setEndDate(new Date());
        Session session = context.getSession();
        if (this.opinion != null) {
            this.task.setOpinion(this.opinion.getOpinion());
        }
        session.update((Object)this.task);
        ProcessService processService = context.getProcessService();
        ProcessInstance processInstance = processService.getProcessInstanceById(this.task.getProcessInstanceId());
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        ProcessDefinition process = processService.getProcessById(this.task.getProcessId());
        Node node = process.getNode(this.task.getNodeName());
        if (node instanceof TaskNode) {
            String taskListenerBean;
            TaskNode taskNode = (TaskNode)node;
            DueDefinition dueDefinition = taskNode.getCustomDueDefinition(processInstance, this.task, context.getApplicationContext());
            if (dueDefinition == null) {
                dueDefinition = taskNode.getDueDefinition();
            }
            if (dueDefinition != null) {
                schedulerService.removeReminderJob(this.task);
            }
            if (StringUtils.isNotEmpty((String)(taskListenerBean = taskNode.getTaskListenerBean()))) {
                TaskListener taskListener = (TaskListener)context.getApplicationContext().getBean(taskListenerBean);
                taskListener.onTaskComplete(context, this.task);
            }
        }
        context.getCommandService().executeCommand(new SaveHistoryTaskCommand(this.task, processInstance));
        if (this.variables != null && this.variables.size() > 0) {
            context.getExpressionContext().addContextVariables(processInstance, this.variables);
            context.getCommandService().executeCommand(new SaveProcessInstanceVariablesCommand(processInstance, this.variables));
        }
        node.leave(context, processInstance, this.flowName);
        return this.task;
    }
}

