/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.TaskType;
import org.apache.commons.lang.StringUtils;

public class ClaimTaskCommand
implements Command<Task> {
    private Task task;
    private String user;

    public ClaimTaskCommand(Task task, String user) {
        this.task = task;
        this.user = user;
    }

    @Override
    public Task execute(Context context) {
        if (!this.task.getType().equals((Object)TaskType.Participative)) {
            throw new IllegalStateException("Current task [" + this.task.getTaskName() + "] is not a participative task!");
        }
        if (StringUtils.isNotEmpty((String)this.task.getAssignee())) {
            throw new IllegalStateException("Current task [" + this.task.getTaskName() + "] has belonged to [" + this.task.getAssignee() + "].");
        }
        if (StringUtils.isBlank((String)this.user)) {
            throw new IllegalStateException("User can not be null when task claim.");
        }
        this.task.setState(TaskState.Reserved);
        this.task.setAssignee(this.user);
        context.getSession().update((Object)this.task);
        return this.task;
    }
}

