/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.impl.SaveHistoryTaskCommand;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessInstance;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.SchedulerService;
import com.bstek.uflo.service.TaskOpinion;
import java.util.Date;
import org.hibernate.Session;

public class CancelTaskCommand
implements Command<Task> {
    private Task task;
    private TaskOpinion opinion;

    public CancelTaskCommand(Task task, TaskOpinion opinion) {
        this.task = task;
        this.opinion = opinion;
    }

    @Override
    public Task execute(Context context) {
        Session session = context.getSession();
        this.task.setState(TaskState.Canceled);
        if (this.opinion != null) {
            this.task.setOpinion(this.opinion.getOpinion());
            this.task.setEndDate(new Date());
        }
        session.update((Object)this.task);
        ProcessService processService = context.getProcessService();
        ProcessInstance processInstance = processService.getProcessInstanceById(this.task.getProcessInstanceId());
        context.getCommandService().executeCommand(new SaveHistoryTaskCommand(this.task, processInstance));
        SchedulerService schedulerService = (SchedulerService)context.getApplicationContext().getBean("uflo.schedulerService");
        schedulerService.removeReminderJob(this.task);
        return this.task;
    }
}

