/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.command.impl.jump.JumpNode;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.StartNode;
import com.bstek.uflo.process.node.TaskNode;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CanWithdrawDecisionCommand
implements Command<Boolean> {
    public Task task;

    public CanWithdrawDecisionCommand(Task task) {
        this.task = task;
    }

    @Override
    public Boolean execute(Context context) {
        ProcessDefinition pd = context.getProcessService().getProcessById(this.task.getProcessId());
        String prevTaskName = this.task.getPrevTask();
        if (StringUtils.isEmpty((String)prevTaskName)) {
            return false;
        }
        if (prevTaskName.equals(this.task.getNodeName())) {
            return false;
        }
        List<JumpNode> nodes = context.getTaskService().getAvaliableRollbackTaskNodes(this.task);
        boolean canJump = false;
        for (JumpNode jumpNode : nodes) {
            if (!jumpNode.getName().equals(prevTaskName)) continue;
            canJump = true;
            break;
        }
        if (!canJump) {
            return false;
        }
        Node currentNode = pd.getNode(this.task.getNodeName());
        Node node = pd.getNode(prevTaskName);
        if (node != null && (node instanceof TaskNode || node instanceof StartNode)) {
            if (node instanceof StartNode && currentNode instanceof StartNode) {
                return false;
            }
            return true;
        }
        return false;
    }
}

