/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.command.impl;

import com.bstek.uflo.command.Command;
import com.bstek.uflo.env.Context;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.model.task.TaskType;
import com.bstek.uflo.process.listener.GlobalTaskListener;
import com.bstek.uflo.process.listener.TaskListener;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.process.node.TaskNode;
import com.bstek.uflo.query.TaskQuery;
import com.bstek.uflo.utils.IDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class AddCountersignCommand
implements Command<Task> {
    private Task task;
    private String username;

    public AddCountersignCommand(Task task, String username) {
        this.task = task;
        this.username = username;
    }

    @Override
    public Task execute(Context context) {
        TaskNode taskNode;
        Object taskListenerBean;
        if (!TaskType.Countersign.equals((Object)this.task.getType())) {
            throw new IllegalArgumentException("Task " + this.task.getId() + " is not a countersign task.");
        }
        Session session = context.getSession();
        TaskQuery query = context.getTaskService().createTaskQuery();
        query.processInstanceId(this.task.getProcessInstanceId());
        query.nodeName(this.task.getNodeName());
        int count = 0;
        for (Task t : (List)query.list()) {
            count = t.getCountersignCount();
            t.setCountersignCount(count + 1);
            session.update((Object)t);
        }
        ProcessDefinition pd = context.getProcessService().getProcessById(this.task.getProcessId());
        Node node = pd.getNode(this.task.getNodeName());
        if (node != null && node instanceof TaskNode && StringUtils.isNotEmpty((String)(taskListenerBean = (taskNode = (TaskNode)node).getTaskListenerBean()))) {
            TaskListener taskListener = (TaskListener)context.getApplicationContext().getBean((String)taskListenerBean);
            taskListener.onTaskCreate(context, this.task);
        }
        Collection coll = context.getApplicationContext().getBeansOfType(GlobalTaskListener.class).values();
        for (GlobalTaskListener listener : coll) {
            listener.onTaskCreate(context, this.task);
        }
        Task newTask = new Task();
        newTask.setAssignee(this.username);
        newTask.setBusinessId(this.task.getBusinessId());
        newTask.setCountersignCount(count + 1);
        newTask.setCreateDate(new Date());
        newTask.setDateUnit(this.task.getDateUnit());
        newTask.setDescription(this.task.getDescription());
        newTask.setDuedate(this.task.getDuedate());
        newTask.setId(IDGenerator.getInstance().nextId());
        newTask.setNodeName(this.task.getNodeName());
        newTask.setOwner(this.task.getOwner());
        newTask.setPrevTask(this.task.getPrevTask());
        newTask.setProcessId(this.task.getProcessId());
        newTask.setProcessInstanceId(this.task.getProcessInstanceId());
        newTask.setState(TaskState.Created);
        newTask.setRootProcessInstanceId(this.task.getRootProcessInstanceId());
        newTask.setTaskName(this.task.getTaskName());
        newTask.setType(this.task.getType());
        newTask.setUrl(this.task.getUrl());
        newTask.setSubject(this.task.getSubject());
        newTask.setPriority(this.task.getPriority());
        session.save((Object)newTask);
        return newTask;
    }
}

