/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.deploy;

import com.bstek.uflo.console.handler.ServletHandler;
import com.bstek.uflo.deploy.validate.ProcessValidateException;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.codehaus.jackson.map.ObjectMapper;

public class DeployServletHandler
implements ServletHandler {
    private ProcessService processService;
    private boolean debug;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String loginUser = EnvironmentUtils.getEnvironment().getLoginUser();
        if (loginUser == null && !this.debug) {
            throw new IllegalArgumentException("Current run mode is not debug.");
        }
        InputStream inputStream = null;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletContext servletContext = req.getSession().getServletContext();
        File repository = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        factory.setRepository(repository);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("utf-8");
        try {
            for (FileItem item : upload.parseRequest(req)) {
                if (!item.getFieldName().equals("processFile")) continue;
                inputStream = item.getInputStream();
            }
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
        if (inputStream != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            try {
                this.processService.deployProcess(inputStream);
                result.put("result", "success");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result.put("result", "fail");
                Throwable exception = this.getCause(ex);
                if (exception instanceof ProcessValidateException) {
                    ProcessValidateException e = (ProcessValidateException)exception;
                    result.put("error", e.getMessage());
                }
                result.put("error", ex.getMessage());
            }
            ObjectMapper mapper = new ObjectMapper();
            resp.setContentType("text/json");
            resp.setCharacterEncoding("UTF-8");
            ServletOutputStream out = resp.getOutputStream();
            try {
                mapper.writeValue((OutputStream)out, result);
            }
            finally {
                out.flush();
                out.close();
            }
        }
        throw new IllegalArgumentException("Can not found uflo process definition!");
    }

    private Throwable getCause(Throwable ex) {
        if (ex.getCause() == null) {
            return ex;
        }
        return this.getCause(ex.getCause());
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public String url() {
        return "/deploy";
    }
}

