/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.uflo.console.handler.impl.central;

import com.bstek.uflo.console.handler.impl.PageData;
import com.bstek.uflo.console.handler.impl.RenderPageServletHandler;
import com.bstek.uflo.model.ProcessDefinition;
import com.bstek.uflo.model.task.Task;
import com.bstek.uflo.model.task.TaskState;
import com.bstek.uflo.process.flow.SequenceFlowImpl;
import com.bstek.uflo.process.node.Node;
import com.bstek.uflo.query.HistoryProcessInstanceQuery;
import com.bstek.uflo.query.HistoryTaskQuery;
import com.bstek.uflo.query.ProcessInstanceQuery;
import com.bstek.uflo.query.ProcessQuery;
import com.bstek.uflo.query.TaskQuery;
import com.bstek.uflo.service.HistoryService;
import com.bstek.uflo.service.ProcessService;
import com.bstek.uflo.service.StartProcessInfo;
import com.bstek.uflo.service.TaskService;
import com.bstek.uflo.utils.EnvironmentUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.jackson.map.ObjectMapper;

public class CentralServletHandler
extends RenderPageServletHandler {
    private ProcessService processService;
    private TaskService taskService;
    private HistoryService historyService;

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = this.retriveMethod(req);
        if (method != null) {
            this.invokeMethod(method, req, resp);
        } else {
            VelocityContext context = new VelocityContext();
            context.put("contextPath", (Object)req.getContextPath());
            resp.setContentType("text/html");
            resp.setCharacterEncoding("utf-8");
            Template template = this.ve.getTemplate("uflo-html/central.html", "utf-8");
            PrintWriter writer = resp.getWriter();
            template.merge((Context)context, (Writer)writer);
            writer.close();
        }
    }

    public void loadHistoryProcessInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Long processId = Long.valueOf(req.getParameter("processId"));
        int pageIndex = Integer.valueOf(req.getParameter("pageIndex"));
        int pageSize = Integer.valueOf(req.getParameter("pageSize"));
        HistoryProcessInstanceQuery historyProcessInstanceQuery = this.historyService.createHistoryProcessInstanceQuery();
        historyProcessInstanceQuery.processId(processId.longValue());
        historyProcessInstanceQuery.addOrderDesc("createDate");
        historyProcessInstanceQuery.page((pageIndex - 1) * pageSize, pageSize);
        int total = historyProcessInstanceQuery.count();
        List list = (List)historyProcessInstanceQuery.list();
        this.writeObjectToJson(resp, new PageData(list, pageSize, pageIndex, total));
    }

    public void loadHistoryTasks(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Long historyProcessInstanceId = Long.valueOf(req.getParameter("historyProcessInstanceId"));
        HistoryTaskQuery historyTaskQuery = this.historyService.createHistoryTaskQuery();
        historyTaskQuery.historyProcessInstanceId(historyProcessInstanceId.longValue());
        List list = (List)historyTaskQuery.list();
        this.writeObjectToJson(resp, list);
    }

    public void loadSequenceFlows(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId = Long.valueOf(req.getParameter("taskId"));
        Task task = this.taskService.getTask(taskId);
        ProcessDefinition pd = this.processService.getProcessById(task.getProcessId());
        Node node = pd.getNode(task.getNodeName());
        ArrayList<SequenceFlowImpl> flows = new ArrayList<SequenceFlowImpl>();
        List list = node.getSequenceFlows();
        if (list != null) {
            for (SequenceFlowImpl flow : list) {
                String flowName = flow.getName();
                if (flowName == null || flowName.startsWith("__temp_flow_")) continue;
                flows.add(flow);
            }
        }
        this.writeObjectToJson(resp, flows);
    }

    public void loadProcess(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String name = req.getParameter("name");
        int pageIndex = Integer.valueOf(req.getParameter("pageIndex"));
        int pageSize = Integer.valueOf(req.getParameter("pageSize"));
        ProcessQuery query = this.processService.createProcessQuery();
        query.addOrderDesc("createDate");
        if (StringUtils.isNotBlank((String)name)) {
            query.nameLike("%" + name + "%");
        }
        int firstResult = (pageIndex - 1) * pageSize;
        query.page(firstResult, pageSize);
        int total = query.count();
        List processes = (List)query.list();
        PageData page = new PageData(processes, pageSize, pageIndex, total);
        this.writeObjectToJson(resp, page);
    }

    public void loadProcessInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ProcessInstanceQuery query = this.processService.createProcessInstanceQuery();
        long processId = Long.valueOf(req.getParameter("processId"));
        int pageIndex = Integer.valueOf(req.getParameter("pageIndex"));
        int pageSize = Integer.valueOf(req.getParameter("pageSize"));
        int firstResult = (pageIndex - 1) * pageSize;
        query.page(firstResult, pageSize);
        query.processId(processId);
        query.addOrderDesc("createDate");
        int total = query.count();
        List list = (List)query.list();
        this.writeObjectToJson(resp, new PageData(list, pageSize, pageIndex, total));
    }

    public void jumpTask(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId = Long.valueOf(req.getParameter("taskId"));
        String nodeName = req.getParameter("nodeName");
        this.taskService.forward(taskId, nodeName);
    }

    public void loadJumpTasks(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId = Long.valueOf(req.getParameter("taskId"));
        List nodes = this.taskService.getAvaliableForwardTaskNodes(taskId);
        this.writeObjectToJson(resp, nodes);
    }

    public void claimTask(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId = Long.valueOf(req.getParameter("taskId"));
        String user = req.getParameter("user");
        this.taskService.claim(taskId, user);
    }

    public void loadCliamUsers(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId = Long.valueOf(req.getParameter("taskId"));
        List list = this.taskService.getTaskParticipators(taskId);
        this.writeObjectToJson(resp, list);
    }

    public void loadTask(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        TaskQuery query = this.taskService.createTaskQuery();
        query.addTaskState(TaskState.Created);
        query.addTaskState(TaskState.InProgress);
        query.addTaskState(TaskState.Ready);
        query.addTaskState(TaskState.Suspended);
        query.addTaskState(TaskState.Reserved);
        Long processInstanceId = Long.valueOf(req.getParameter("processInstanceId"));
        query.processInstanceId(processInstanceId.longValue());
        query.addOrderDesc("createDate");
        this.writeObjectToJson(resp, query.list());
    }

    public void startProcess(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long processId = Long.valueOf(req.getParameter("processId"));
        StartProcessInfo startProcessInfo = new StartProcessInfo(EnvironmentUtils.getEnvironment().getLoginUser());
        startProcessInfo.setCompleteStartTask(true);
        String variables = req.getParameter("variables");
        Map<String, Object> variableMaps = this.buildVariables(variables);
        if (variableMaps != null) {
            startProcessInfo.setVariables(variableMaps);
        }
        this.processService.startProcessById(processId, startProcessInfo);
    }

    public void deleteProcess(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long processId = Long.valueOf(req.getParameter("processId"));
        this.processService.deleteProcess(processId);
    }

    public void deleteProcessInstance(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long processInstanceId = Long.valueOf(req.getParameter("processInstanceId"));
        this.processService.deleteProcessInstanceById(processInstanceId);
    }

    public void completeTask(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        long taskId = Long.valueOf(req.getParameter("taskId"));
        String sequenceFlowName = req.getParameter("flowName");
        String variables = req.getParameter("variables");
        Map<String, Object> variableMaps = this.buildVariables(variables);
        this.taskService.start(taskId);
        if (variableMaps != null) {
            if (StringUtils.isBlank((String)sequenceFlowName)) {
                this.taskService.complete(taskId, variableMaps);
            } else {
                this.taskService.complete(taskId, sequenceFlowName, variableMaps);
            }
        } else {
            this.taskService.complete(taskId);
        }
    }

    private Map<String, Object> buildVariables(String variables) {
        if (StringUtils.isBlank((String)variables)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            List list = (List)mapper.readValue(variables, ArrayList.class);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Map m : list) {
                String key = m.get("key").toString();
                Object value = m.get("value");
                map.put(key, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    @Override
    public String url() {
        return "/central";
    }
}

