/*
 * Decompiled with CFR 0.152.
 */
package com.brunomnsilva.smartgraph.graphview;

import javafx.geometry.Point2D;

public class UtilitiesPoint2D {
    public static Point2D rotate(Point2D point, Point2D pivot, double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double sin = Math.sin(angleRadians);
        double cos = Math.cos(angleRadians);
        double translatedX = point.getX() - pivot.getX();
        double translatedY = point.getY() - pivot.getY();
        double rotatedX = translatedX * cos - translatedY * sin;
        double rotatedY = translatedX * sin + translatedY * cos;
        return new Point2D(rotatedX += pivot.getX(), rotatedY += pivot.getY());
    }

    public static Point2D calculateTriangleBetween(Point2D pointA, Point2D pointB, double angleDegrees) {
        Point2D midpointAB = pointA.midpoint(pointB);
        double slopeAB = (pointB.getY() - pointA.getY()) / (pointB.getX() - pointA.getX());
        double perpendicularSlope = -1.0 / slopeAB;
        if (Double.isInfinite(perpendicularSlope)) {
            double yC = midpointAB.getY() + Math.tan(Math.toRadians(angleDegrees)) * midpointAB.getX();
            return new Point2D(midpointAB.getX(), yC);
        }
        if (perpendicularSlope == 0.0) {
            return new Point2D(pointA.getX(), midpointAB.getY());
        }
        double angleAB = Math.toDegrees(Math.atan2(pointB.getY() - pointA.getY(), pointB.getX() - pointA.getX()));
        double angleAC = angleAB + angleDegrees;
        double distanceAC = pointA.distance(midpointAB) / Math.cos(Math.toRadians(angleDegrees));
        double xC = pointA.getX() + distanceAC * Math.cos(Math.toRadians(angleAC));
        double yC = perpendicularSlope * (xC - midpointAB.getX()) + midpointAB.getY();
        return new Point2D(xC, yC);
    }
}

